/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jobs;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import io.dropwizard.jobs.GuiceJobFactory;
import io.dropwizard.jobs.Job;
import io.dropwizard.jobs.JobConfiguration;
import io.dropwizard.jobs.JobManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.quartz.spi.JobFactory;

public class GuiceJobManager
extends JobManager {
    private final GuiceJobFactory jobFactory;

    public GuiceJobManager(JobConfiguration config, Injector injector) {
        super(config, GuiceJobManager.getJobs(injector));
        this.jobFactory = new GuiceJobFactory(injector);
    }

    static List<Job> getJobs(Injector injector) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        Map bindings = injector.getBindings();
        for (Key key : bindings.keySet()) {
            TypeLiteral typeLiteral = key.getTypeLiteral();
            Class clazz = typeLiteral.getRawType();
            if (!Job.class.isAssignableFrom(clazz)) continue;
            jobs.add((Job)injector.getInstance(clazz));
        }
        return jobs;
    }

    protected JobFactory getJobFactory() {
        return this.jobFactory;
    }
}

