/*
 * Decompiled with CFR 0.152.
 */
package org.jsonrepairj;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import lombok.NonNull;
import org.jsonrepairj.FixInfo;
import org.jsonrepairj.Json;
import org.jsonrepairj.ParseResult;
import org.jsonrepairj.parser.JSONParser;

public class JsonRepair {
    public static ParseResult parseJson(@NonNull String jsonStr, boolean skipJsonLoads, boolean streamStable) {
        ParseResult parsedJson;
        if (jsonStr == null) {
            throw new NullPointerException("jsonStr is marked non-null but is null");
        }
        JSONParser parser = new JSONParser(jsonStr, streamStable);
        if (skipJsonLoads) {
            parsedJson = parser.parse();
        } else {
            try {
                JsonNode node = Json.MAPPER.readTree(jsonStr);
                parsedJson = new ParseResult(node, new ArrayList<FixInfo>());
            }
            catch (Exception e) {
                parsedJson = parser.parse();
            }
        }
        return parsedJson;
    }

    public static String repairJson(String jsonStr) {
        ParseResult result = JsonRepair.parseJson(jsonStr, false, false);
        if (result.getJson().isMissingNode()) {
            return "";
        }
        try {
            return Json.MAPPER.writeValueAsString((Object)result.getJson());
        }
        catch (Exception e) {
            return "";
        }
    }
}

