/*
 * Decompiled with CFR 0.152.
 */
package org.jsonrepairj.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.jsonrepairj.Constants;
import org.jsonrepairj.Json;
import org.jsonrepairj.ObjectComparer;
import org.jsonrepairj.StringOps;
import org.jsonrepairj.parser.ContextValue;
import org.jsonrepairj.parser.JSONParser;
import org.jsonrepairj.parser.NodeParser;

public class ArrayParser
implements NodeParser {
    @Override
    public JsonNode parse(JSONParser parser) {
        ArrayNode array = Json.FACTORY.arrayNode();
        parser.getContext().set(ContextValue.ARRAY);
        char ch = parser.getCharAt();
        while (StringOps.notIn(ch, '\u0000', ']', '}')) {
            JsonNode value;
            parser.skipWhitespacesAt();
            if (Constants.STRING_DELIMITERS.contains(Character.valueOf(ch))) {
                int i = 1;
                i = parser.skipToCharacter(ch, i);
                value = parser.getCharAt(i = parser.skipWhitespacesAt(i + 1, false)) == ':' ? parser.parseObject() : parser.parseString();
            } else {
                value = parser.parseJson();
            }
            if (ObjectComparer.isStrictlyEmpty(value)) {
                parser.shift();
            } else if (value instanceof TextNode && value.textValue().equals("...") && parser.getCharAt(-1) == '.') {
                parser._log("While parsing an array, found a stray '...'; ignoring it");
            } else if (!(value instanceof MissingNode)) {
                array.add(value);
            }
            ch = parser.getCharAt();
            while (StringOps.notIn(ch, '\u0000', ']', '}') && (Character.isWhitespace(ch) || ch == ',')) {
                parser.shift();
                ch = parser.getCharAt();
            }
        }
        if (StringOps.notIn(ch, '\u0000', ']', '}')) {
            parser._log("While parsing an array we missed the closing ], ignoring it");
        }
        parser.shift();
        parser.getContext().reset();
        return array;
    }
}

