/*
 * Decompiled with CFR 0.152.
 */
package org.jsonrepairj.parser;

import com.fasterxml.jackson.databind.JsonNode;
import org.jsonrepairj.Json;
import org.jsonrepairj.parser.JSONParser;
import org.jsonrepairj.parser.NodeParser;

public class BooleanNullParser
implements NodeParser {
    static final String[] values = new String[]{"true", "false", "null"};

    @Override
    public JsonNode parse(JSONParser parser) {
        int startingIndex = parser.getIndex();
        char ch = Character.toLowerCase(parser.getCharAt());
        for (int v = 0; v < values.length; ++v) {
            int i;
            String value = values[v];
            if (ch != value.charAt(0)) continue;
            for (i = 0; ch != '\u0000' && i < value.length() && ch == value.charAt(i); ++i) {
                parser.shift();
                ch = Character.toLowerCase(parser.getCharAt());
            }
            if (i != value.length()) continue;
            switch (value) {
                case "true": {
                    return Json.FACTORY.booleanNode(true);
                }
                case "false": {
                    return Json.FACTORY.booleanNode(false);
                }
                case "null": {
                    return Json.FACTORY.nullNode();
                }
            }
        }
        parser.setIndex(startingIndex);
        return Json.FACTORY.missingNode();
    }
}

