/*
 * Decompiled with CFR 0.152.
 */
package org.jsonrepairj.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jsonrepairj.Json;
import org.jsonrepairj.parser.ContextValue;
import org.jsonrepairj.parser.JSONParser;
import org.jsonrepairj.parser.NodeParser;

public class CommentParser
implements NodeParser {
    @Override
    public JsonNode parse(JSONParser parser) {
        char ch = parser.getCharAt();
        ArrayList terminationCharacters = Lists.newArrayList((Object[])new Character[]{Character.valueOf('\n'), Character.valueOf('\r')});
        if (parser.getContext().contains(ContextValue.ARRAY)) {
            terminationCharacters.add(Character.valueOf(']'));
        }
        if (parser.getContext().contains(ContextValue.OBJECT_VALUE)) {
            terminationCharacters.add(Character.valueOf('}'));
        }
        if (parser.getContext().contains(ContextValue.OBJECT_KEY)) {
            terminationCharacters.add(Character.valueOf(':'));
        }
        if (ch == '#') {
            StringBuilder comment = new StringBuilder();
            while (ch != '\u0000' && !CommentParser.contains(terminationCharacters, ch)) {
                comment.append(ch);
                parser.shift();
                ch = parser.getCharAt();
            }
            parser._log(String.format("Found line comment: %s, ignoring", comment));
        } else if (ch == '/') {
            char nextChar = parser.getCharAt(1);
            if (nextChar == '/') {
                StringBuilder comment = new StringBuilder("//");
                parser.setIndex(parser.getIndex() + 2);
                ch = parser.getCharAt();
                while (ch != '\u0000' && !CommentParser.contains(terminationCharacters, ch)) {
                    comment.append(ch);
                    parser.shift();
                    ch = parser.getCharAt();
                }
                parser._log(String.format("Found line comment: %s, ignoring", comment));
            } else if (nextChar == '*') {
                StringBuilder comment = new StringBuilder("/*");
                parser.shift(2);
                do {
                    if ((ch = parser.getCharAt()) == '\u0000') {
                        parser._log("Reached end-of-string while parsing block comment; unclosed block comment.");
                        break;
                    }
                    comment.append(ch);
                    parser.shift();
                } while (comment.length() < 2 || comment.charAt(comment.length() - 2) != '*' || comment.charAt(comment.length() - 1) != '/');
                parser._log(String.format("Found block comment: %s, ignoring", comment));
            } else {
                parser.shift();
            }
        }
        if (parser.getContext().isEmpty()) {
            return parser.parseJson();
        }
        return Json.FACTORY.missingNode();
    }

    private static boolean contains(List<Character> array, char value) {
        return array.contains(Character.valueOf(value));
    }
}

