/*
 * Decompiled with CFR 0.152.
 */
package org.jsonrepairj.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;
import org.jsonrepairj.Constants;
import org.jsonrepairj.FixInfo;
import org.jsonrepairj.Json;
import org.jsonrepairj.ParseResult;
import org.jsonrepairj.StringOps;
import org.jsonrepairj.parser.ArrayParser;
import org.jsonrepairj.parser.BooleanNullParser;
import org.jsonrepairj.parser.CommentParser;
import org.jsonrepairj.parser.ContextValue;
import org.jsonrepairj.parser.JsonContext;
import org.jsonrepairj.parser.NumberParser;
import org.jsonrepairj.parser.ObjectParser;
import org.jsonrepairj.parser.StringParser;

public class JSONParser {
    private final ArrayParser array;
    private final BooleanNullParser booleanNull;
    private final NumberParser number;
    private final StringParser string;
    private final ObjectParser object;
    private final CommentParser comment;
    private String jsonStr;
    private boolean streamStable;
    private int index;
    private JsonContext context;
    private List<FixInfo> logger;

    public JSONParser(String jsonStr, boolean streamStable) {
        this.jsonStr = jsonStr != null ? jsonStr : "";
        this.streamStable = streamStable;
        this.index = 0;
        this.context = new JsonContext();
        this.logger = new ArrayList<FixInfo>();
        this.array = new ArrayParser();
        this.booleanNull = new BooleanNullParser();
        this.number = new NumberParser();
        this.object = new ObjectParser();
        this.string = new StringParser();
        this.comment = new CommentParser();
    }

    public ParseResult parse() {
        JsonNode json = this.parseJson();
        if (this.index < this.jsonStr.length()) {
            this._log("The parser returned early, checking if there's more json elements");
            ArrayNode arrayNode = Json.FACTORY.arrayNode();
            arrayNode.add(json);
            while (this.index < this.jsonStr.length()) {
                JsonNode j = this.parseJson();
                if (!(j instanceof MissingNode)) {
                    arrayNode.add(j);
                    continue;
                }
                ++this.index;
            }
            if (arrayNode.size() == 1) {
                this._log("There were no more elements, returning the element without the array");
            } else {
                json = arrayNode;
            }
        }
        return new ParseResult(json, this.logger);
    }

    public JsonNode parseJson() {
        char ch;
        while ((ch = this.getCharAt()) != '\u0000') {
            if (ch == '{') {
                ++this.index;
                return this.parseObject();
            }
            if (ch == '[') {
                ++this.index;
                return this.parseArray();
            }
            if (!this.context.isEmpty() && (Constants.STRING_DELIMITERS.contains(Character.valueOf(ch)) || Character.isLetter(ch))) {
                return this.parseString();
            }
            if (!this.context.isEmpty() && (Character.isDigit(ch) || ch == '-' || ch == '.')) {
                return this.parseNumber();
            }
            if (StringOps.in(ch, '#', '/')) {
                return this.parseComment();
            }
            ++this.index;
        }
        return Json.MAPPER.missingNode();
    }

    public char getCharAt() {
        return this.getCharAt(0);
    }

    public char getCharAt(int count) {
        if (this.jsonStr.length() > this.index + count) {
            return this.jsonStr.charAt(this.index + count);
        }
        return '\u0000';
    }

    public void _log(String text) {
        int window = 10;
        int start = Math.max(this.index - window, 0);
        int end = Math.min(this.index + window, this.jsonStr.length());
        String contextStr = this.jsonStr.substring(start, end);
        this.logger.add(new FixInfo(text, contextStr));
    }

    public JsonNode parseObject() {
        return this.object.parse(this);
    }

    public JsonNode parseArray() {
        return this.array.parse(this);
    }

    public JsonNode parseString() {
        return this.string.parse(this);
    }

    public JsonNode parseNumber() {
        return this.number.parse(this);
    }

    public JsonNode parseComment() {
        return this.comment.parse(this);
    }

    public JsonNode parseBooleanOrNull() {
        return this.booleanNull.parse(this);
    }

    public int skipWhitespacesAt() {
        return this.skipWhitespacesAt(0, true);
    }

    public int skipWhitespacesAt(int idx, boolean moveMainIndex) {
        if (this.index + idx >= this.jsonStr.length()) {
            return idx;
        }
        char ch = this.jsonStr.charAt(this.index + idx);
        while (Character.isWhitespace(ch)) {
            if (moveMainIndex) {
                ++this.index;
            } else {
                ++idx;
            }
            if (this.index + idx >= this.jsonStr.length()) {
                return idx;
            }
            ch = this.jsonStr.charAt(this.index + idx);
        }
        return idx;
    }

    public int skipToCharacter(char character) {
        return this.skipToCharacter(character, 0);
    }

    public int skipToCharacter(char character, int idx) {
        return this.skipToCharacter(new char[]{character}, idx);
    }

    public int skipToCharacter(char[] characters, int idx) {
        if (this.index + idx >= this.jsonStr.length()) {
            return idx;
        }
        char ch = this.jsonStr.charAt(this.index + idx);
        HashSet<Character> charSet = new HashSet<Character>();
        for (char c : characters) {
            charSet.add(Character.valueOf(c));
        }
        while (!charSet.contains(Character.valueOf(ch))) {
            if (this.index + ++idx >= this.jsonStr.length()) {
                return idx;
            }
            ch = this.jsonStr.charAt(this.index + idx);
        }
        if (this.jsonStr.charAt(this.index + idx - 1) == '\\') {
            return this.skipToCharacter(characters, idx + 1);
        }
        return idx;
    }

    public void shift() {
        ++this.index;
    }

    public void shift(int i) {
        this.index += i;
    }

    public ContextValue getCurrentContext() {
        return this.context.getCurrent();
    }

    public String toString() {
        return String.format("[%d](%c) %s", this.index, Character.valueOf(this.getCharAt()), this.context);
    }

    @Generated
    public String getJsonStr() {
        return this.jsonStr;
    }

    @Generated
    public void setJsonStr(String jsonStr) {
        this.jsonStr = jsonStr;
    }

    @Generated
    public boolean isStreamStable() {
        return this.streamStable;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public JsonContext getContext() {
        return this.context;
    }
}

