/*
 * Decompiled with CFR 0.152.
 */
package org.jsonrepairj.parser;

import com.fasterxml.jackson.databind.JsonNode;
import org.jsonrepairj.Constants;
import org.jsonrepairj.Json;
import org.jsonrepairj.StringOps;
import org.jsonrepairj.parser.ContextValue;
import org.jsonrepairj.parser.JSONParser;
import org.jsonrepairj.parser.NodeParser;

public class NumberParser
implements NodeParser {
    @Override
    public JsonNode parse(JSONParser parser) {
        boolean isArray;
        StringBuilder number = new StringBuilder();
        char ch = parser.getCharAt();
        boolean bl = isArray = parser.getCurrentContext() == ContextValue.ARRAY;
        while (ch != '\u0000' && Constants.NUMBER_CHARS.contains(Character.valueOf(ch)) && (!isArray || ch != ',')) {
            number.append(ch);
            parser.shift();
            ch = parser.getCharAt();
        }
        if (number.length() > 0 && StringOps.in(StringOps.last(number), '-', 'e', 'E', '/', ',')) {
            number.setLength(number.length() - 1);
            parser.shift(-1);
        } else if (parser.getCharAt() != '\u0000' && Character.isLetter(parser.getCharAt())) {
            parser.shift(-number.length());
            return parser.parseString();
        }
        if (number.length() == 0) {
            return Json.FACTORY.missingNode();
        }
        if (number.indexOf(",") != -1) {
            return Json.FACTORY.textNode(number.toString());
        }
        try {
            if (number.indexOf(".") != -1 || number.indexOf("e") != -1 || number.indexOf("E") != -1) {
                return Json.FACTORY.numberNode(Double.parseDouble(number.toString()));
            }
            return Json.FACTORY.numberNode(Long.parseLong(number.toString()));
        }
        catch (NumberFormatException e) {
            return Json.FACTORY.textNode(number.toString());
        }
    }
}

