/*
 * Decompiled with CFR 0.152.
 */
package org.jsonrepairj.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jsonrepairj.Json;
import org.jsonrepairj.StringOps;
import org.jsonrepairj.parser.ContextValue;
import org.jsonrepairj.parser.JSONParser;
import org.jsonrepairj.parser.NodeParser;

public class ObjectParser
implements NodeParser {
    @Override
    public JsonNode parse(JSONParser parser) {
        ObjectNode obj = Json.FACTORY.objectNode();
        ArrayList keys = Lists.newArrayList();
        while (parser.getCharAt() != '\u0000' && parser.getCharAt() != '}') {
            parser.skipWhitespacesAt();
            if (parser.getCharAt() == ':') {
                parser._log("While parsing an object we found a : before a key, ignoring");
                parser.shift();
            }
            parser.getContext().set(ContextValue.OBJECT_KEY);
            int rollbackIndex = parser.getIndex();
            String key = "";
            while (parser.getCharAt() != '\u0000') {
                JsonNode keyNode;
                rollbackIndex = parser.getIndex();
                if (parser.getCharAt() == '[' && key.equals("")) {
                    String prevKey;
                    String string = prevKey = !keys.isEmpty() ? (String)keys.get(keys.size() - 1) : null;
                    if (prevKey != null && obj.get(prevKey).isArray()) {
                        parser.shift();
                        JsonNode newArray = parser.parseArray();
                        if (newArray instanceof ArrayNode) {
                            JsonNode prevValue = obj.get(prevKey);
                            if (prevValue instanceof ArrayNode) {
                                ((ArrayNode)prevValue).addAll((ArrayNode)newArray);
                            }
                            parser.skipWhitespacesAt();
                            if (parser.getCharAt() == ',') {
                                parser.shift();
                            }
                            parser.skipWhitespacesAt();
                            continue;
                        }
                    }
                }
                if ((key = (keyNode = parser.parseString()) instanceof TextNode ? keyNode.textValue() : "").equals("")) {
                    parser.skipWhitespacesAt();
                }
                if (key.equals("") && (!key.equals("") || parser.getCharAt() != ':' && parser.getCharAt() != '}')) continue;
                break;
            }
            if (parser.getContext().contains(ContextValue.ARRAY) && obj.has(key)) {
                parser._log("While parsing an object we found a duplicate key, closing the object here and rolling back the index");
                parser.setIndex(rollbackIndex - 1);
                String jsonStr = parser.getJsonStr();
                jsonStr = jsonStr.substring(0, parser.getIndex() + 1) + "{" + jsonStr.substring(parser.getIndex() + 1);
                parser.setJsonStr(jsonStr);
                break;
            }
            parser.skipWhitespacesAt();
            if (StringOps.in(parser.getCharAt(), '\u0000', '}')) continue;
            parser.skipWhitespacesAt();
            if (parser.getCharAt() != ':') {
                parser._log("While parsing an object we missed a : after a key");
            }
            parser.shift();
            parser.getContext().reset();
            parser.getContext().set(ContextValue.OBJECT_VALUE);
            parser.skipWhitespacesAt();
            JsonNode value = Json.FACTORY.missingNode();
            if (StringOps.in(parser.getCharAt(), ',', '}')) {
                parser._log("While parsing an object value we found a stray , ignoring it");
            } else {
                value = parser.parseJson();
            }
            parser.getContext().reset();
            obj.set(key, value);
            keys.add(key);
            if (StringOps.in(parser.getCharAt(), '\u0000', ',', '\'', '\"')) {
                parser.shift();
            }
            parser.skipWhitespacesAt();
        }
        parser.shift();
        return obj;
    }
}

