/*
 * Decompiled with CFR 0.152.
 */
package org.jsonrepairj.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jsonrepairj.Constants;
import org.jsonrepairj.Json;
import org.jsonrepairj.StringOps;
import org.jsonrepairj.parser.ContextValue;
import org.jsonrepairj.parser.JSONParser;
import org.jsonrepairj.parser.NodeParser;

public class StringParser
implements NodeParser {
    static final Map<Character, Character> ESCAPE_SEQS = ImmutableMap.of((Object)Character.valueOf('t'), (Object)Character.valueOf('\t'), (Object)Character.valueOf('n'), (Object)Character.valueOf('\n'), (Object)Character.valueOf('r'), (Object)Character.valueOf('\r'), (Object)Character.valueOf('b'), (Object)Character.valueOf('\b'));

    @Override
    public JsonNode parse(JSONParser parser) {
        boolean missingQuotes = false;
        boolean doubledQuotes = false;
        char lstringDelimiter = '\"';
        char rstringDelimiter = '\"';
        char ch = parser.getCharAt();
        if (ch == '#' || ch == '/') {
            return parser.parseComment();
        }
        while (ch != '\u0000' && !Constants.STRING_DELIMITERS.contains(Character.valueOf(ch)) && !Character.isLetterOrDigit(ch)) {
            parser.shift();
            ch = parser.getCharAt();
        }
        if (ch == '\u0000') {
            return Json.FACTORY.missingNode();
        }
        if (ch == '\'') {
            rstringDelimiter = '\'';
            lstringDelimiter = '\'';
        } else if (ch == '\u201c') {
            lstringDelimiter = '\u201c';
            rstringDelimiter = '\u201d';
        } else if (Character.isLetterOrDigit(ch)) {
            JsonNode value;
            if ("tfn".indexOf(Character.toLowerCase(ch)) != -1 && parser.getCurrentContext() != ContextValue.OBJECT_KEY && !(value = parser.parseBooleanOrNull()).isMissingNode()) {
                return value;
            }
            parser._log("While parsing a string, we found a literal instead of a quote");
            missingQuotes = true;
        }
        if (!missingQuotes) {
            parser.shift();
        }
        if (Constants.STRING_DELIMITERS.contains(Character.valueOf(parser.getCharAt())) && parser.getCharAt() == lstringDelimiter) {
            if (parser.getCurrentContext() == ContextValue.OBJECT_KEY && parser.getCharAt(1) == ':' || parser.getCurrentContext() == ContextValue.OBJECT_VALUE && (parser.getCharAt(1) == ',' || parser.getCharAt(1) == '}')) {
                parser.shift();
                return Json.EMPTY_STRING;
            }
            if (parser.getCharAt(1) == lstringDelimiter) {
                parser._log("While parsing a string, we found a doubled quote and then a quote again, ignoring it");
                return Json.EMPTY_STRING;
            }
            int i = parser.skipToCharacter(rstringDelimiter, 1);
            char nextC = parser.getCharAt(i);
            if (nextC != '\u0000' && parser.getCharAt(i + 1) == rstringDelimiter) {
                parser._log("While parsing a string, we found a valid starting doubled quote");
                doubledQuotes = true;
                parser.shift();
            } else {
                i = parser.skipWhitespacesAt(1, false);
                nextC = parser.getCharAt(i);
                if (nextC != '\u0000' && (Constants.STRING_DELIMITERS.contains(Character.valueOf(nextC)) || nextC == '{' || nextC == '[')) {
                    parser._log("While parsing a string, we found a doubled quote but also another quote afterwards, ignoring it");
                    parser.shift();
                    return Json.EMPTY_STRING;
                }
                if (",]}".indexOf(nextC) == -1) {
                    parser._log("While parsing a string, we found a doubled quote but it was a mistake, removing one quote");
                    parser.shift();
                }
            }
        }
        StringBuilder stringAcc = new StringBuilder();
        ch = parser.getCharAt();
        boolean unmatchedDelimiter = false;
        while (StringOps.notIn(ch, '\u0000', rstringDelimiter)) {
            int i;
            block60: {
                boolean rstringDelimiterMissing;
                block63: {
                    int i2;
                    char nextC;
                    block61: {
                        block64: {
                            block62: {
                                if (missingQuotes) {
                                    if (parser.getCurrentContext() == ContextValue.OBJECT_KEY && (ch == ':' || Character.isWhitespace(ch))) {
                                        parser._log("While parsing a string missing the left delimiter in object key context, we found a :, stopping here");
                                        break;
                                    }
                                    if (parser.getCurrentContext() == ContextValue.ARRAY && StringOps.in(ch, ']', ',')) {
                                        parser._log("While parsing a string missing the left delimiter in array context, we found a ] or ,, stopping here");
                                        break;
                                    }
                                }
                                if (parser.isStreamStable() || parser.getCurrentContext() != ContextValue.OBJECT_VALUE || !StringOps.in(ch, ',', '}') || stringAcc.length() != 0 && StringOps.last(stringAcc) == rstringDelimiter) break block60;
                                rstringDelimiterMissing = true;
                                parser.skipWhitespacesAt();
                                if (parser.getCharAt(1) == '\\') {
                                    rstringDelimiterMissing = false;
                                }
                                if ((nextC = parser.getCharAt(i2 = parser.skipToCharacter(rstringDelimiter, 1))) == '\u0000') break block61;
                                ++i2;
                                nextC = parser.getCharAt(i2 = parser.skipWhitespacesAt(i2, false));
                                if (!StringOps.in(nextC, '\u0000', ',', '}')) break block62;
                                rstringDelimiterMissing = false;
                                break block63;
                            }
                            nextC = parser.getCharAt(i2 = parser.skipToCharacter(lstringDelimiter, i2));
                            if (nextC != '\u0000') break block64;
                            rstringDelimiterMissing = false;
                            break block63;
                        }
                        nextC = parser.getCharAt(i2 = parser.skipWhitespacesAt(i2 + 1, false));
                        if (nextC == '\u0000' || nextC == ':') break block63;
                        rstringDelimiterMissing = false;
                        break block63;
                    }
                    i2 = parser.skipToCharacter(':', 1);
                    nextC = parser.getCharAt(i2);
                    if (nextC != '\u0000') break;
                    i2 = parser.skipWhitespacesAt(1, false);
                    int j = parser.skipToCharacter('}', i2);
                    if (j - i2 > 1) {
                        rstringDelimiterMissing = false;
                    } else if (parser.getCharAt(j) != '\u0000') {
                        for (int k = stringAcc.length() - 1; k >= 0; --k) {
                            if (stringAcc.charAt(k) != '{') continue;
                            rstringDelimiterMissing = false;
                            break;
                        }
                    }
                }
                if (rstringDelimiterMissing) {
                    parser._log("While parsing a string missing the left delimiter in object value context, we found a , or } and we couldn't determine that a right delimiter was present. Stopping here");
                    break;
                }
            }
            if (!parser.isStreamStable() && ch == ']' && parser.getContext().contains(ContextValue.ARRAY) && StringOps.last(stringAcc) != rstringDelimiter && parser.getCharAt(i = parser.skipToCharacter(rstringDelimiter)) == '\u0000') break;
            stringAcc.append(ch);
            parser.shift();
            ch = parser.getCharAt();
            if (parser.isStreamStable() && ch != '\u0000' && StringOps.last(stringAcc) == '\\') {
                stringAcc.setLength(stringAcc.length() - 1);
            }
            if (ch != '\u0000' && StringOps.last(stringAcc) == '\\') {
                parser._log("Found a stray escape sequence, normalizing it");
                if (StringOps.in(ch, rstringDelimiter, 't', 'n', 'r', 'b', '\\')) {
                    StringOps.setLast(stringAcc, ESCAPE_SEQS.getOrDefault(Character.valueOf(ch), Character.valueOf(ch)).charValue());
                    parser.shift();
                    ch = parser.getCharAt();
                    while (ch != '\u0000' && StringOps.last(stringAcc) == '\\' && StringOps.in(ch, rstringDelimiter, '\\')) {
                        StringOps.setLast(stringAcc, ch);
                        parser.shift();
                        ch = parser.getCharAt();
                    }
                    continue;
                }
                if (StringOps.in(ch, 'u', 'x')) {
                    int numChars = ch == 'u' ? 4 : 2;
                    String nextChars = parser.getJsonStr().substring(parser.getIndex() + 1, parser.getIndex() + 1 + numChars);
                    if (nextChars.length() == numChars && nextChars.chars().allMatch(c -> "0123456789abcdefABCDEF".indexOf(c) != -1)) {
                        parser._log("Found a unicode escape sequence, normalizing it");
                        StringOps.setLast(stringAcc, (char)Integer.parseInt(nextChars, 16));
                        parser.shift(1 + numChars);
                        ch = parser.getCharAt();
                        continue;
                    }
                } else if (Constants.STRING_DELIMITERS.contains(Character.valueOf(ch)) && ch != rstringDelimiter) {
                    parser._log("Found a delimiter that was escaped but shouldn't be escaped, removing the escape");
                    StringOps.setLast(stringAcc, ch);
                    parser.shift();
                    ch = parser.getCharAt();
                    continue;
                }
            }
            if (ch == ':' && !missingQuotes && parser.getCurrentContext() == ContextValue.OBJECT_KEY) {
                i = parser.skipToCharacter(lstringDelimiter, 1);
                char nextC = parser.getCharAt(i);
                if (nextC != '\u0000') {
                    ++i;
                    nextC = parser.getCharAt(i = parser.skipToCharacter(rstringDelimiter, i));
                    if (nextC != '\u0000') {
                        ++i;
                        nextC = parser.getCharAt(i = parser.skipWhitespacesAt(i, false));
                        if (StringOps.in(nextC, ',', '}')) {
                            parser._log("While parsing a string missing the right delimiter in object key context, we found a :, stopping here");
                            break;
                        }
                    }
                } else {
                    parser._log("While parsing a string missing the right delimiter in object key context, we found a :, stopping here");
                    break;
                }
            }
            if (ch != rstringDelimiter || StringOps.last(stringAcc) == '\\') continue;
            if (doubledQuotes && parser.getCharAt(1) == rstringDelimiter) {
                parser._log("While parsing a string, we found a doubled quote, ignoring it");
                parser.shift();
                continue;
            }
            if (missingQuotes && parser.getCurrentContext() == ContextValue.OBJECT_VALUE) {
                i = 1;
                char nextC = parser.getCharAt(i);
                while (!StringOps.notIn(nextC, '\u0000', rstringDelimiter, lstringDelimiter)) {
                    nextC = parser.getCharAt(++i);
                }
                if (nextC == '\u0000') continue;
                ++i;
                nextC = parser.getCharAt(i = parser.skipWhitespacesAt(i, false));
                if (nextC != ':') continue;
                parser.shift(-1);
                ch = parser.getCharAt();
                parser._log("In a string with missing quotes and object value context, I found a delimeter but it turns out it was the beginning on the next key. Stopping here.");
                break;
            }
            if (unmatchedDelimiter) {
                unmatchedDelimiter = false;
                stringAcc.append(ch);
                parser.shift();
                ch = parser.getCharAt();
                continue;
            }
            i = 1;
            char nextC = parser.getCharAt(i);
            boolean checkCommaInObjectValue = true;
            while (nextC != '\u0000' && nextC != rstringDelimiter && nextC != lstringDelimiter) {
                if (checkCommaInObjectValue && Character.isLetterOrDigit(nextC)) {
                    checkCommaInObjectValue = false;
                }
                if (parser.getContext().contains(ContextValue.OBJECT_KEY) && StringOps.in(nextC, ':', '}') || parser.getContext().contains(ContextValue.OBJECT_VALUE) && nextC == '}' || parser.getContext().contains(ContextValue.ARRAY) && StringOps.in(nextC, ']', ',') || checkCommaInObjectValue && parser.getCurrentContext() == ContextValue.OBJECT_VALUE && nextC == ',') break;
                nextC = parser.getCharAt(++i);
            }
            if (nextC == ',' && parser.getCurrentContext() == ContextValue.OBJECT_VALUE) {
                ++i;
                i = parser.skipToCharacter(rstringDelimiter, i);
                nextC = parser.getCharAt(i);
                ++i;
                nextC = parser.getCharAt(i = parser.skipWhitespacesAt(i, false));
                if (nextC != '}' && nextC != ',') continue;
                parser._log("While parsing a string, we a misplaced quote that would have closed the string but has a different meaning here, ignoring it");
                stringAcc.append(ch);
                parser.shift();
                ch = parser.getCharAt();
                continue;
            }
            if (nextC != rstringDelimiter || parser.getCharAt(i - 1) == '\\') continue;
            boolean allSpace = true;
            for (int j = 1; j < i; ++j) {
                if (Character.isWhitespace(parser.getCharAt(j))) continue;
                allSpace = false;
                break;
            }
            if (allSpace) break;
            if (parser.getCurrentContext() == ContextValue.OBJECT_VALUE) {
                if (parser.getCharAt(i = parser.skipWhitespacesAt(i + 1, false)) == ',') {
                    i = parser.skipToCharacter(lstringDelimiter, i + 1);
                    ++i;
                    i = parser.skipToCharacter(rstringDelimiter, i + 1);
                    ++i;
                    nextC = parser.getCharAt(i = parser.skipWhitespacesAt(i, false));
                    if (nextC == ':') {
                        parser._log("\"While parsing a string, we a misplaced quote that would have closed the string but has a different meaning here, ignoring it");
                        stringAcc.append(ch);
                        parser.shift();
                        ch = parser.getCharAt();
                        continue;
                    }
                }
                i = parser.skipToCharacter(rstringDelimiter, i + 1);
                nextC = parser.getCharAt(++i);
                while (StringOps.notIn(nextC, '\u0000', ':') && !StringOps.in(nextC, ',', '}', ']') && (nextC != rstringDelimiter || parser.getCharAt(i - 1) == '\\')) {
                    nextC = parser.getCharAt(++i);
                }
                if (nextC == ':') continue;
                parser._log("While parsing a string, we a misplaced quote that would have closed the string but has a different meaning here, ignoring it");
                unmatchedDelimiter = !unmatchedDelimiter;
                stringAcc.append(ch);
                parser.shift();
                ch = parser.getCharAt();
                continue;
            }
            if (parser.getCurrentContext() == ContextValue.ARRAY) {
                boolean evenDelimiters;
                char[] limit = new char[]{rstringDelimiter, ']'};
                nextC = parser.getCharAt(i = parser.skipToCharacter(limit, i + 1));
                boolean bl = evenDelimiters = nextC != '\u0000' && nextC == rstringDelimiter;
                while (evenDelimiters && nextC != '\u0000' && nextC == rstringDelimiter) {
                    i = parser.skipToCharacter(limit, i + 1);
                    i = parser.skipToCharacter(limit, i + 1);
                    nextC = parser.getCharAt(i);
                }
                if (!evenDelimiters || nextC == ']') break;
                parser._log("While parsing a string in Array context, we detected a quoted section that would have closed the string but has a different meaning here, ignoring it");
                unmatchedDelimiter = !unmatchedDelimiter;
                stringAcc.append(ch);
                parser.shift();
                ch = parser.getCharAt();
                continue;
            }
            if (parser.getCurrentContext() != ContextValue.OBJECT_KEY) continue;
            parser._log("While parsing a string in Object Key context, we detected a quoted section that would have closed the string but has a different meaning here, ignoring it");
            stringAcc.append(ch);
            parser.shift();
            ch = parser.getCharAt();
        }
        if (ch != '\u0000' && missingQuotes && parser.getCurrentContext() == ContextValue.OBJECT_KEY && Character.isWhitespace(ch)) {
            parser._log("While parsing a string, handling an extreme corner case in which the LLM added a comment instead of valid string, invalidate the string and return an empty value");
            parser.skipWhitespacesAt();
            char c2 = parser.getCharAt();
            if (c2 != ':' && c2 != ',') {
                return Json.EMPTY_STRING;
            }
        }
        if (ch != rstringDelimiter) {
            if (!parser.isStreamStable()) {
                parser._log("While parsing a string, we missed the closing quote, ignoring");
                StringOps.rstrip(stringAcc);
            }
        } else {
            parser.shift();
        }
        if (!parser.isStreamStable() && (missingQuotes || StringOps.last(stringAcc) == '\n')) {
            StringOps.rstrip(stringAcc);
        }
        return Json.FACTORY.textNode(stringAcc.toString());
    }
}

