/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.cdb;

import io.github.duckasteroid.cdb.CdbElement;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;

public class CdbElementEnumeration
implements Enumeration<CdbElement>,
Closeable {
    private final ReadableByteChannel in;
    private final int eod;
    private final ByteBuffer lengthBuffer = ByteBuffer.allocateDirect(8).order(ByteOrder.LITTLE_ENDIAN);
    private int pos;

    public CdbElementEnumeration(ReadableByteChannel in, int eod) {
        this.in = in;
        this.eod = eod;
        this.pos = 2048;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized boolean hasMoreElements() {
        return this.pos < this.eod;
    }

    @Override
    public synchronized CdbElement nextElement() {
        try {
            this.lengthBuffer.clear();
            this.pos += this.in.read(this.lengthBuffer);
            this.lengthBuffer.flip();
            int klen = this.lengthBuffer.getInt();
            int dlen = this.lengthBuffer.getInt();
            ByteBuffer keyBuffer = this.readBuffer(klen);
            ByteBuffer dataBuffer = this.readBuffer(dlen);
            return new CdbElement(keyBuffer.asReadOnlyBuffer(), dataBuffer.asReadOnlyBuffer());
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Invalid cdb format", ioException);
        }
    }

    private ByteBuffer readBuffer(int len) throws IOException {
        int count;
        byte[] bytes = new byte[len];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        for (int off = 0; off < len; off += count) {
            count = this.in.read(buffer);
            if (count != -1) continue;
            throw new IllegalArgumentException("Invalid cdb format");
        }
        this.pos += len;
        return buffer.flip();
    }
}

