/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.cdb;

import io.github.duckasteroid.cdb.Cdb;
import io.github.duckasteroid.cdb.CdbHashPointer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public final class CdbMake {
    private RandomAccessFile file = null;
    private List<CdbHashPointer> hashPointers = null;
    private int[] tableCount = null;
    private int[] tableStart = null;
    private int pos = -1;

    public static void make(String dataFilepath, String cdbFilepath, String tempFilepath) throws IOException {
        CdbMake.make(dataFilepath, cdbFilepath, tempFilepath, null);
    }

    public static void make(String dataFilepath, String cdbFilepath, String tempFilepath, Cdb ignoreCdb) throws IOException {
        CdbMake.make(dataFilepath, new File(cdbFilepath), new File(tempFilepath), ignoreCdb);
    }

    public static void make(String dataFilepath, File cdbFilepath, File tempFilepath, Cdb ignoreCdb) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(dataFilepath));
        CdbMake.make((InputStream)in, cdbFilepath, tempFilepath, ignoreCdb);
        in.close();
    }

    public static void make(InputStream in, String cdbFilepath, String tempFilepath) throws IOException {
        CdbMake.make(in, cdbFilepath, tempFilepath, null);
    }

    public static void make(InputStream in, String cdbFilepath, String tempFilepath, Cdb ignoreCdb) throws IOException {
        CdbMake.make(in, new File(cdbFilepath), new File(tempFilepath), ignoreCdb);
    }

    public static void make(InputStream in, File cdbFilepath, File tempFilepath, Cdb ignoreCdb) throws IOException {
        int ch;
        CdbMake cdbMake = new CdbMake();
        cdbMake.start(tempFilepath);
        while ((ch = in.read()) != -1 && ch != 10) {
            if (ch != 43) {
                throw new IllegalArgumentException("input file not in correct format");
            }
            int klen = 0;
            while ((ch = in.read()) != 44) {
                if (ch < 48 || ch > 57) {
                    throw new IllegalArgumentException("input file not in correct format");
                }
                if (klen > 0x19999990) {
                    throw new IllegalArgumentException("key length is too big");
                }
                klen = klen * 10 + (ch - 48);
            }
            int dlen = 0;
            while ((ch = in.read()) != 58) {
                if (ch < 48 || ch > 57) {
                    throw new IllegalArgumentException("input file not in correct format");
                }
                if (dlen > 0x19999990) {
                    throw new IllegalArgumentException("data length is too big");
                }
                dlen = dlen * 10 + (ch - 48);
            }
            byte[] key = new byte[klen];
            for (int i = 0; i < klen; ++i) {
                ch = in.read();
                if (ch == -1) {
                    throw new IllegalArgumentException("input file is truncated");
                }
                key[i] = (byte)(ch & 0xFF);
            }
            ch = in.read();
            if (ch != 45) {
                throw new IllegalArgumentException("input file not in correct format");
            }
            ch = in.read();
            if (ch != 62) {
                throw new IllegalArgumentException("input file not in correct format");
            }
            byte[] data = new byte[dlen];
            for (int i = 0; i < dlen; ++i) {
                ch = in.read();
                if (ch == -1) {
                    throw new IllegalArgumentException("input file is truncated");
                }
                data[i] = (byte)(ch & 0xFF);
            }
            if (ignoreCdb == null || ignoreCdb.find(ByteBuffer.wrap(data)) == null) {
                cdbMake.add(key, data);
            }
            if ((ch = in.read()) == 10) continue;
            throw new IllegalArgumentException("input file not in correct format");
        }
        cdbMake.finish();
        boolean rename = tempFilepath.renameTo(cdbFilepath);
        if (!rename) {
            throw new IOException("Unable to rename to " + cdbFilepath.getAbsolutePath());
        }
    }

    public void start(File filepath) throws IOException {
        this.hashPointers = new LinkedList<CdbHashPointer>();
        this.tableCount = new int[256];
        this.tableStart = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.tableCount[i] = 0;
        }
        this.file = new RandomAccessFile(filepath, "rw");
        this.pos = 2048;
        this.file.seek(this.pos);
    }

    public void add(byte[] key, byte[] data) throws IOException {
        this.writeLeInt(key.length);
        this.writeLeInt(data.length);
        this.file.write(key);
        this.file.write(data);
        long hash = Cdb.hash(ByteBuffer.wrap(key));
        this.hashPointers.add(new CdbHashPointer(hash, this.pos));
        int n = (int)(hash & 0xFFL);
        this.tableCount[n] = this.tableCount[n] + 1;
        this.posplus(8);
        this.posplus(key.length);
        this.posplus(data.length);
    }

    public void finish() throws IOException {
        int curEntry = 0;
        for (int i = 0; i < 256; ++i) {
            this.tableStart[i] = curEntry += this.tableCount[i];
        }
        CdbHashPointer[] slotPointers = new CdbHashPointer[this.hashPointers.size()];
        for (CdbHashPointer hp : this.hashPointers) {
            int n = (int)(hp.hash & 0xFFL);
            int n2 = this.tableStart[n] - 1;
            this.tableStart[n] = n2;
            slotPointers[n2] = hp;
        }
        byte[] slotTable = new byte[2048];
        for (int i = 0; i < 256; ++i) {
            CdbHashPointer hp;
            int u;
            int len = this.tableCount[i] * 2;
            slotTable[i * 8] = (byte)(this.pos & 0xFF);
            slotTable[i * 8 + 1] = (byte)(this.pos >>> 8 & 0xFF);
            slotTable[i * 8 + 2] = (byte)(this.pos >>> 16 & 0xFF);
            slotTable[i * 8 + 3] = (byte)(this.pos >>> 24 & 0xFF);
            slotTable[i * 8 + 4] = (byte)(len & 0xFF);
            slotTable[i * 8 + 4 + 1] = (byte)(len >>> 8 & 0xFF);
            slotTable[i * 8 + 4 + 2] = (byte)(len >>> 16 & 0xFF);
            slotTable[i * 8 + 4 + 3] = (byte)(len >>> 24 & 0xFF);
            int curSlotPointer = this.tableStart[i];
            CdbHashPointer[] hashTable = new CdbHashPointer[len];
            for (u = 0; u < this.tableCount[i]; ++u) {
                hp = slotPointers[curSlotPointer++];
                int where = (int)((hp.hash >>> 8) % (long)len);
                while (hashTable[where] != null) {
                    if (++where != len) continue;
                    where = 0;
                }
                hashTable[where] = hp;
            }
            for (u = 0; u < len; ++u) {
                hp = hashTable[u];
                if (hp != null) {
                    this.writeLeInt((int)hashTable[u].hash);
                    this.writeLeInt(hashTable[u].pos);
                } else {
                    this.writeLeInt(0);
                    this.writeLeInt(0);
                }
                this.posplus(8);
            }
        }
        this.file.seek(0L);
        this.file.write(slotTable);
        this.file.close();
    }

    private void writeLeInt(int v) throws IOException {
        this.file.writeByte((byte)(v & 0xFF));
        this.file.writeByte((byte)(v >>> 8 & 0xFF));
        this.file.writeByte((byte)(v >>> 16 & 0xFF));
        this.file.writeByte((byte)(v >>> 24 & 0xFF));
    }

    private void posplus(int count) throws IOException {
        int newpos = this.pos + count;
        if (newpos < count) {
            throw new IOException("CdbRunner file is too big.");
        }
        this.pos = newpos;
    }
}

