/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress;

import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;

public class Configuration {
    private static final Configuration singleton = Configuration.load();
    private final transient Properties source;

    public Configuration(Properties source) {
        this.source = source;
    }

    private static Configuration load() {
        return new Configuration(System.getProperties());
    }

    public static Configuration getInstance() {
        return singleton;
    }

    public Optional<String> getStringValue(String prop) {
        return Optional.ofNullable(this.source.getProperty(prop));
    }

    public Integer getInteger(String name, Integer defaultValue) {
        return this.getValue(name, Integer::parseInt, defaultValue);
    }

    public Long getLong(String name, Long defaultValue) {
        return this.getValue(name, Long::parseLong, defaultValue);
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.getValue(name, Boolean::parseBoolean, defaultValue);
    }

    public String getString(String name, String defaultValue) {
        return this.getValue(name, Function.identity(), defaultValue);
    }

    public boolean hasValueFor(String name) {
        return this.getStringValue(name).isPresent();
    }

    public <T> T getValue(String name, Function<String, T> parser, T defaultValue) {
        return (T)this.getStringValue(name).map(parser::apply).orElse(defaultValue);
    }
}

