/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.BaseProgressMonitor;
import io.github.duckasteroid.progress.base.event.ProgressMonitorListener;
import io.github.duckasteroid.progress.base.event.ProgressMonitorListenerFactory;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class ProgressMonitorFactory {
    private static List<ProgressMonitorListener> listeners = ProgressMonitorFactory.fromServiceLoader();

    private static List<ProgressMonitorListener> fromServiceLoader() {
        ServiceLoader<ProgressMonitorListener> listenerServiceLoader = ServiceLoader.load(ProgressMonitorListener.class);
        List tmp = listenerServiceLoader.stream().map(p -> (ProgressMonitorListener)p.get()).collect(Collectors.toList());
        if (tmp.isEmpty()) {
            System.err.println("Bad configuration - no ProgressMonitorListeners found");
        }
        return new CopyOnWriteArrayList<ProgressMonitorListener>(tmp);
    }

    public static void addListener(ProgressMonitorListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(ProgressMonitorListener listener) {
        listeners.remove(listener);
    }

    public static void clearListeners() {
        listeners.clear();
    }

    public static void resetListeners() {
        listeners = ProgressMonitorFactory.fromServiceLoader();
    }

    public static final ProgressMonitor newMonitor(String name, long size) {
        BaseProgressMonitor monitor = new BaseProgressMonitor(name, size, listeners);
        ServiceLoader.load(ProgressMonitorListenerFactory.class).stream().map(ServiceLoader.Provider::get).map(fac -> fac.createProgressMonitorListener(name)).forEach(monitor::addProgressMonitorListener);
        return monitor;
    }
}

