/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.base;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.SubTaskProgressMonitor;
import io.github.duckasteroid.progress.base.event.ProgressUpdateType;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractProgressMonitor
implements ProgressMonitor {
    private static final long DEFAULT_SIZE = 1L;
    protected final transient int id;
    protected final String taskName;
    protected final AtomicBoolean done = new AtomicBoolean(false);
    protected transient AtomicInteger childId = new AtomicInteger(0);
    protected transient CopyOnWriteArrayList<AbstractProgressMonitor> children = new CopyOnWriteArrayList();
    protected String status = "";
    protected transient AtomicLong workDone = new AtomicLong(0L);
    protected AtomicLong size = new AtomicLong(1L);
    protected String unit = "";

    public AbstractProgressMonitor(int id, String name) {
        this.id = id;
        this.taskName = name;
    }

    public int compareTo(ProgressMonitor o) {
        if (Objects.equals(this.getParent(), o)) {
            return Integer.MIN_VALUE;
        }
        if (Objects.equals(this.getParent(), o.getParent()) && o instanceof AbstractProgressMonitor) {
            return this.id - ((AbstractProgressMonitor)o).id;
        }
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractProgressMonitor)) {
            return false;
        }
        AbstractProgressMonitor that = (AbstractProgressMonitor)o;
        return this.id == that.id && Objects.equals(this.getParent(), that.getParent());
    }

    public int hashCode() {
        return Objects.hash(this.getParent(), this.id);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
        if (!this.isDone()) {
            this.notifyListeners(this, ProgressUpdateType.STATUS);
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public long getSize() {
        return this.size.get();
    }

    public void setSize(long size) throws IllegalArgumentException {
        this.size.set(size);
        this.updateWork(this.workDone.get(), size, this.done.get());
    }

    public long getWorkDone() {
        return this.workDone.get();
    }

    public long worked(long amount) {
        return this.worked(amount, null);
    }

    public long worked(long amount, String status) {
        boolean done;
        long size;
        long targetWorked;
        long worked;
        boolean set;
        amount = Math.max(0L, amount);
        do {
            size = this.size.get();
            done = this.done.get();
        } while (!(set = this.workDone.compareAndSet(worked = this.workDone.get(), targetWorked = worked + amount)));
        if (status != null) {
            this.status = status;
        }
        this.updateWork(targetWorked, size, done);
        return targetWorked;
    }

    public boolean isDone() {
        return this.workDone.get() >= this.size.get();
    }

    public void done() {
        if (!this.isDone()) {
            boolean done;
            long targetWorked;
            long worked;
            boolean set;
            do {
                done = this.done.get();
            } while (!(set = this.workDone.compareAndSet(worked = this.workDone.get(), targetWorked = this.size.get())));
            this.updateWork(targetWorked, targetWorked, done);
        }
    }

    protected void updateWork(long work, long size, boolean done) {
        if (done) {
            this.latchDone();
        } else if (work > 0L) {
            this.notifyListeners(this, ProgressUpdateType.WORK);
            if (this.isDone()) {
                this.latchDone();
            }
        }
    }

    private void latchDone() {
        boolean updated = this.done.compareAndSet(false, true);
        if (updated) {
            this.notifyListeners(this, ProgressUpdateType.DONE);
            this.onDone();
        }
    }

    public abstract void notifyListeners(ProgressMonitor var1, ProgressUpdateType var2);

    protected abstract void onDone();

    public double getFractionDone() {
        return (double)this.workDone.get() / (double)this.size.get();
    }

    public ProgressMonitor newSubTask(String name) {
        return this.newSubTask(name, 1L);
    }

    public ProgressMonitor newSubTask(String name, long work) {
        SubTaskProgressMonitor subTask = new SubTaskProgressMonitor(this, this.childId.getAndIncrement(), work, name);
        this.children.add(subTask);
        return subTask;
    }

    protected void removeSubTask(SubTaskProgressMonitor subTask) {
        this.children.remove(subTask);
    }

    protected void appendActive(List<ProgressMonitor> active) {
        if (!this.isDone()) {
            active.add(this);
            for (AbstractProgressMonitor child : this.children) {
                child.appendActive(active);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {taskName='" + this.taskName + "', status='" + this.status + "', workDone=" + this.workDone + ", size=" + this.size + "}";
    }
}

