/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.base;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.AbstractProgressMonitor;
import io.github.duckasteroid.progress.base.event.ProgressMonitorEvent;
import io.github.duckasteroid.progress.base.event.ProgressMonitorListener;
import io.github.duckasteroid.progress.base.event.ProgressUpdateType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public final class BaseProgressMonitor
extends AbstractProgressMonitor
implements ProgressMonitor {
    protected final transient List<ProgressMonitorListener> listeners = new CopyOnWriteArrayList<ProgressMonitorListener>();
    protected AtomicBoolean cancelled = new AtomicBoolean(false);

    public BaseProgressMonitor() {
        this("");
    }

    public BaseProgressMonitor(String name) {
        super(0, name);
    }

    public BaseProgressMonitor(String name, long size) {
        this(name);
        this.setSize(size);
    }

    public BaseProgressMonitor(String name, long size, Collection<ProgressMonitorListener> listeners) {
        this(name);
        this.setSize(size);
        this.listeners.addAll(listeners);
    }

    public BaseProgressMonitor(long size) {
        this();
        this.setSize(size);
    }

    public void addProgressMonitorListener(ProgressMonitorListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressMonitorListener(ProgressMonitorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void notifyListeners(ProgressMonitor source, ProgressUpdateType updateType) {
        ProgressMonitorEvent event = new ProgressMonitorEvent(this, source, updateType);
        for (ProgressMonitorListener listener : this.listeners) {
            listener.logUpdate(event);
        }
    }

    @Override
    protected void onDone() {
    }

    public List<ProgressMonitor> getAllActive() {
        ArrayList<ProgressMonitor> active = new ArrayList<ProgressMonitor>(this.children.size() + 1);
        this.appendActive(active);
        return active;
    }

    public ProgressMonitor getParent() {
        return null;
    }

    public List<ProgressMonitor> getContext() {
        return Collections.emptyList();
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled.set(cancelled);
        if (cancelled) {
            this.notifyListeners(this, ProgressUpdateType.CANCELLED);
        }
    }
}

