/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.base;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.AbstractProgressMonitor;
import io.github.duckasteroid.progress.base.event.ProgressUpdateType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SubTaskProgressMonitor
extends AbstractProgressMonitor {
    protected final List<ProgressMonitor> context;
    protected final AbstractProgressMonitor parent;
    protected final transient long totalParentWork;

    public SubTaskProgressMonitor(AbstractProgressMonitor parent, int id, long totalParentWork, String name) {
        super(id, name);
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        this.parent = parent;
        if (totalParentWork < 0L) {
            throw new IllegalArgumentException("Parent work must be zero or positive");
        }
        this.totalParentWork = totalParentWork;
        LinkedList<AbstractProgressMonitor> tmp = new LinkedList<AbstractProgressMonitor>(parent.getContext());
        tmp.addLast(parent);
        this.context = Collections.unmodifiableList(tmp);
    }

    @Override
    protected void onDone() {
        this.parent.worked(this.totalParentWork, this.taskName);
        this.parent.removeSubTask(this);
    }

    public ProgressMonitor getParent() {
        return this.parent;
    }

    public List<ProgressMonitor> getContext() {
        return this.context;
    }

    public boolean isCancelled() {
        return this.parent.isCancelled();
    }

    public void setCancelled(boolean cancelled) {
        this.parent.setCancelled(cancelled);
    }

    @Override
    public void notifyListeners(ProgressMonitor source, ProgressUpdateType updateType) {
        this.parent.notifyListeners(source, updateType);
    }
}

