/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.base.event;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.BaseProgressMonitor;
import io.github.duckasteroid.progress.base.event.ProgressUpdateType;
import java.util.Objects;

public class ProgressMonitorEvent {
    private final ProgressMonitor source;
    private final BaseProgressMonitor root;
    private final ProgressUpdateType type;

    public ProgressMonitorEvent(BaseProgressMonitor root, ProgressMonitor source, ProgressUpdateType type) {
        this.root = root;
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null");
        }
        this.source = source;
        this.type = type;
    }

    public BaseProgressMonitor getRoot() {
        return this.root;
    }

    public ProgressMonitor getSource() {
        return this.source;
    }

    public ProgressUpdateType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgressMonitorEvent that = (ProgressMonitorEvent)o;
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }

    public String toString() {
        return "ProgressMonitorEvent{root=" + this.root + ", source=" + this.source + ", type=" + this.type + "}";
    }
}

