/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.console;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.format.elements.FormatElement;
import java.util.Optional;

public class Colourizer
implements FormatElement.Wrapping {
    public static final String RESET_COLOR = "\u001b[0m";
    private final transient String ansiColorCode;
    private transient FormatElement wrapped;

    public Colourizer(String ansiColorCode, FormatElement wrapped) {
        this.ansiColorCode = ansiColorCode;
        this.wrapped = wrapped;
    }

    public Colourizer(String ansiColorCode) {
        this.ansiColorCode = ansiColorCode;
    }

    public static Colourizer wrap(FormatElement element, Color c) {
        return new Colourizer(c.code, element);
    }

    public void setWrapped(FormatElement wrapped) {
        this.wrapped = wrapped;
    }

    public boolean isWrapping() {
        return this.wrapped != null;
    }

    public void appendTo(StringBuilder sb, ProgressMonitor monitor) {
        if (this.wrapped != null) {
            sb.append("\u001b[").append(this.ansiColorCode).append("m");
            this.wrapped.appendTo(sb, monitor);
            sb.append(RESET_COLOR);
        }
    }

    public static enum Color {
        BLACK("30"),
        RED("31"),
        GREEN("32"),
        YELLOW("33");

        private final String code;

        private Color(String code) {
            this.code = code;
        }

        public static Optional<Color> parse(String s) {
            for (Color c : Color.values()) {
                if (!c.name().equals(s)) continue;
                return Optional.of(c);
            }
            return Optional.empty();
        }

        public String getCode() {
            return this.code;
        }
    }
}

