/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.console;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.BaseProgressMonitor;
import io.github.duckasteroid.progress.base.event.ProgressMonitorEvent;
import io.github.duckasteroid.progress.base.event.ProgressMonitorListener;
import io.github.duckasteroid.progress.base.event.ProgressUpdateType;
import io.github.duckasteroid.progress.base.format.ProgressFormat;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;

public class ConsoleProgress
implements ProgressMonitorListener {
    public static final String CLEAR_LINE = "\u001b[2K";
    public static final String CURSOR_UP_1 = "\u001b[1A";
    public static final String CURSOR_DOWN_1 = "\u001b[1B";
    public static final String ERASE_DOWN = "\u001b[J";
    private final transient PrintStream output;
    private final transient ProgressFormat formatter;
    private final transient boolean multiline;
    private transient Semaphore semaphore = new Semaphore(1, false);
    private transient StringBuilder eraser = new StringBuilder();

    public ConsoleProgress(PrintStream output, ProgressFormat formatter, boolean multiline) {
        this.output = output;
        this.formatter = formatter;
        this.multiline = multiline;
    }

    public static ProgressMonitor createConsoleMonitor(ProgressFormat format, boolean multiline) {
        BaseProgressMonitor monitor = new BaseProgressMonitor();
        monitor.addProgressMonitorListener((ProgressMonitorListener)new ConsoleProgress(System.out, format, multiline));
        return monitor;
    }

    public void logUpdate(ProgressMonitorEvent event) {
        if (this.semaphore.tryAcquire()) {
            try {
                this.outputToConsole(event);
            }
            finally {
                this.semaphore.release();
            }
        }
    }

    private void outputToConsole(ProgressMonitorEvent event) {
        if (event.getType() != ProgressUpdateType.DONE) {
            List<ProgressMonitor> toPrint = this.multiline ? event.getRoot().getAllActive() : Collections.singletonList(event.getSource());
            if (this.eraser.length() > 0) {
                this.output.print(this.eraser.toString());
                this.eraser = new StringBuilder(this.eraser.length());
            }
            StringBuilder rewinder = new StringBuilder();
            for (ProgressMonitor monitor : toPrint) {
                String formatted = this.formatter.format(monitor);
                this.output.println(formatted);
                rewinder.append(CURSOR_UP_1);
                this.eraser.append("\u001b[2K\u001b[1B");
            }
            this.eraser.append("\r" + rewinder.toString());
            this.output.print(rewinder.toString());
            this.output.flush();
        }
    }
}

