/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.base.format;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.format.CompoundFormat;
import io.github.duckasteroid.progress.base.format.ProgressFormat;
import io.github.duckasteroid.progress.base.format.elements.FormatElement;
import io.github.duckasteroid.progress.base.format.elements.Fraction;
import io.github.duckasteroid.progress.base.format.elements.Percentage;
import io.github.duckasteroid.progress.base.format.elements.StaticString;
import io.github.duckasteroid.progress.base.format.elements.Status;
import io.github.duckasteroid.progress.base.format.elements.StringWrapper;
import io.github.duckasteroid.progress.base.format.elements.TaskName;
import io.github.duckasteroid.progress.base.format.elements.Unit;
import java.util.ArrayList;

public class SimpleProgressFormat
implements ProgressFormat {
    public static final ProgressFormat DEFAULT = SimpleProgressFormat.createSimpleProgressFormat(true, true, true, true, true, true);
    private final transient boolean showParents;
    private final transient ProgressFormat format;

    private SimpleProgressFormat(boolean showParents, ProgressFormat format) {
        this.showParents = showParents;
        this.format = format;
    }

    public static SimpleProgressFormat createSimpleProgressFormat(boolean showParents, boolean showTask, boolean showWork, boolean showUnit, boolean showPercent, boolean showStatus) {
        ArrayList<FormatElement> elements = new ArrayList<FormatElement>(8);
        if (showTask) {
            elements.add(new TaskName());
        }
        if (showWork) {
            if (!elements.isEmpty()) {
                elements.add(StaticString.CONDITIONAL_WHITESPACE);
            }
            elements.add(new StringWrapper("[", new Fraction(), "]"));
        }
        if (showUnit) {
            if (!elements.isEmpty()) {
                elements.add(StaticString.CONDITIONAL_WHITESPACE);
            }
            elements.add(new Unit());
        }
        if (showPercent) {
            if (!elements.isEmpty()) {
                elements.add(StaticString.CONDITIONAL_WHITESPACE);
            }
            elements.add(new StringWrapper("(", new Percentage(), ")"));
        }
        if (showStatus) {
            if (!elements.isEmpty()) {
                elements.add(new StaticString(" - ", false));
            }
            elements.add(new Status());
        }
        return new SimpleProgressFormat(showParents, new CompoundFormat(elements));
    }

    @Override
    public String format(ProgressMonitor monitor) {
        StringBuilder sb = new StringBuilder();
        if (this.showParents && monitor.getParent() != null) {
            String parent = this.format(monitor.getParent());
            sb.append(parent).append("> ");
        }
        sb.append(this.format.format(monitor));
        return sb.toString();
    }
}

