/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.base.format.elements;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.format.elements.FormatElement;
import java.util.Arrays;

public class ProgressBar
implements FormatElement {
    public static final char[] BAR_EQUALS = new char[]{'=', '>', ' '};
    private static final int MIN_WIDTH = 1;
    private static final int MIN_BAR_CHARS = 3;
    private final transient char[] barChars;
    private final transient String fullBar;
    private final transient String emptyBar;
    private final transient int width;

    public ProgressBar(int width, char[] barChars) {
        if (width <= 1) {
            throw new IllegalArgumentException("Width must be > 1");
        }
        this.width = width;
        this.barChars = barChars;
        if (barChars != null) {
            if (barChars.length < 3) {
                throw new IllegalArgumentException("Bar chars should contain 4 chars");
            }
        } else {
            throw new IllegalArgumentException("Bar chars should not be null");
        }
        char[] tmp = new char[width];
        Arrays.fill(tmp, barChars[0]);
        this.fullBar = new String(tmp);
        Arrays.fill(tmp, barChars[2]);
        this.emptyBar = new String(tmp);
    }

    @Override
    public void appendTo(StringBuilder sb, ProgressMonitor monitor) {
        int percent = Math.max(0, (int)(monitor.getWorkDone() * (long)this.width / monitor.getSize()));
        sb.append(this.fullBar.substring(this.width - percent)).append(this.barChars[1]).append(this.emptyBar.substring(percent));
    }
}

