/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.base.format.elements;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.format.elements.FormatElement;

public class Spinner
implements FormatElement {
    public static final char[] SPINNER_SLASHES = new char[]{'-', '\\', '|', '/'};
    private static final int MIN_SPIN_CHARS = 2;
    private final transient char[] spinnerChars;
    private transient int spindex = 0;

    public Spinner(char[] spinnerChars) {
        if (spinnerChars == null) {
            throw new IllegalArgumentException("Spinner chars cannot be null");
        }
        if (spinnerChars.length < 2) {
            throw new IllegalArgumentException("Spinner chars length must be 2 or more");
        }
        this.spinnerChars = spinnerChars;
    }

    @Override
    public void appendTo(StringBuilder sb, ProgressMonitor monitor) {
        sb.append(this.spinnerChars[this.spindex++]);
        if (this.spindex >= this.spinnerChars.length) {
            this.spindex = 0;
        }
    }
}

