/*
 * Decompiled with CFR 0.152.
 */
package io.github.duckasteroid.progress.base.format.elements;

import io.github.duckasteroid.progress.ProgressMonitor;
import io.github.duckasteroid.progress.base.format.elements.FormatElement;

public class StringWrapper
implements FormatElement {
    private final transient String before;
    private final transient String after;
    private final transient FormatElement wrapped;

    public StringWrapper(String before, FormatElement wrapped, String after) {
        this.before = before;
        this.wrapped = wrapped;
        this.after = after;
    }

    public static StringWrapper prefix(String prefix, FormatElement wrapped) {
        return new StringWrapper(prefix, wrapped, "");
    }

    public static FormatElement wrap(String before, FormatElement wrap, String after) {
        return new StringWrapper(before, wrap, after);
    }

    @Override
    public void appendTo(StringBuilder sb, ProgressMonitor monitor) {
        if (this.wrapped.hasContent(monitor)) {
            sb.append(this.before);
            this.wrapped.appendTo(sb, monitor);
            sb.append(this.after);
        }
    }

    @Override
    public boolean hasContent(ProgressMonitor monitor) {
        return this.wrapped.hasContent(monitor);
    }
}

