/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer.Audio;

import android.content.Context;
import android.media.AudioTrack;
import com.eafy.zjlog.ZJLog;
import com.eafy.zjmediaplayer.Audio.ZJAudioCollecter;
import com.eafy.zjmediaplayer.Audio.ZJAudioSessionManager;

public class ZJAudioAECPlayer {
    private Context mContext = null;
    private AudioTrack mAudioTrack = null;
    private int mPlaySampleRate = 0;
    private int mPlayChannels = 0;
    private boolean isPlay = false;
    public boolean mMute = false;
    private Boolean isSpeakerMode = null;
    private boolean isCallMode = false;
    private ZJAudioCollecter mAudioCollecter = null;
    private int mCollectSampleRate = 0;
    private int mCollectChannels = 0;
    private int mCollectBitrate = 0;
    private boolean mAecEnable = false;
    public boolean isCollectAAC = true;

    public void setContext(Context context) {
        this.mContext = context;
    }

    public int getPlaySampleRate() {
        return this.mPlaySampleRate;
    }

    public int getPlayChannels() {
        return this.mPlayChannels;
    }

    public int getCollectSampleRate() {
        return this.mCollectSampleRate;
    }

    public int getCollectChannels() {
        return this.mCollectChannels;
    }

    public void configPlay(int sampleRate, int channels) {
        this.mPlaySampleRate = sampleRate;
        this.mPlayChannels = channels;
    }

    public void start() {
        this.isPlay = true;
        this.configAudioPlayer();
        this.initAudioPlayer();
    }

    public void stop() {
        this.isPlay = false;
        this.releaseAudioPlayer();
        this.releaseAudioCollecter();
    }

    public void stopPlay() {
        this.isPlay = false;
        this.releaseAudioPlayer();
    }

    public boolean isPlaying() {
        return this.isPlay;
    }

    public void setSpeakerMode(Boolean isSpeakerMode, boolean isCallMode) {
        this.isSpeakerMode = isSpeakerMode;
        this.isCallMode = isCallMode;
        if (this.mPlaySampleRate == 0) {
            return;
        }
        if (isSpeakerMode != null) {
            if (isSpeakerMode.booleanValue()) {
                ZJAudioSessionManager.shared().changeMode(isCallMode ? 4 : 2);
            } else {
                ZJAudioSessionManager.shared().changeMode(3);
            }
            this.isSpeakerMode = null;
        } else {
            ZJAudioSessionManager.shared().changeMode(2);
        }
    }

    public void loadPcmData(byte[] pcmData, int sampleRate, int channels) {
        if (sampleRate > 0 && channels > 0 && (this.mPlaySampleRate != sampleRate || this.mPlayChannels != channels)) {
            this.mPlaySampleRate = sampleRate;
            this.mPlayChannels = channels;
            this.releaseAudioPlayer();
            this.releaseAudioCollecter();
            this.initAudioPlayer();
        }
        if (this.mMute) {
            return;
        }
        if (!this.isPlay) {
            return;
        }
        this.play(pcmData);
    }

    public void play(byte[] audioData) {
        if (audioData == null) {
            return;
        }
        if (this.mAudioTrack == null || !this.isPlay) {
            return;
        }
        this.mAudioTrack.write(audioData, 0, audioData.length);
    }

    private void initAudioPlayer() {
        int sessionId = this.startCollect();
        if (this.mAudioTrack != null) {
            return;
        }
        if (this.mPlaySampleRate <= 0) {
            return;
        }
        this.setSpeakerMode(this.isSpeakerMode, this.isCallMode);
        int channelConfig = 4;
        int audioFormat = 2;
        int minBufSize = AudioTrack.getMinBufferSize((int)this.mPlaySampleRate, (int)channelConfig, (int)audioFormat);
        this.mAudioTrack = sessionId > 0 ? new AudioTrack(3, this.mPlaySampleRate, channelConfig, audioFormat, minBufSize, 1, sessionId) : new AudioTrack(3, this.mPlaySampleRate, channelConfig, audioFormat, minBufSize, 1);
        this.mAudioTrack.play();
        ZJLog.d((String)"Audio player init success");
    }

    private void configAudioPlayer() {
        if (this.mPlaySampleRate <= 0 && this.mCollectSampleRate > 0) {
            this.mPlaySampleRate = this.mCollectSampleRate;
        }
        if (this.mPlayChannels <= 0 && this.mCollectChannels > 0) {
            this.mPlayChannels = this.mCollectChannels;
        }
    }

    private void releaseAudioPlayer() {
        if (this.mAudioTrack != null) {
            this.mAudioTrack.pause();
            this.mAudioTrack.release();
            this.mAudioTrack = null;
            ZJLog.d((String)"Audio player is released");
        }
    }

    private void initAudioCollecter() {
        if (this.mAudioCollecter != null) {
            return;
        }
        this.mAudioCollecter = new ZJAudioCollecter(this.mContext);
        ZJLog.d((String)"Audio player init collecter");
    }

    private void configAudioCollecter() {
        this.initAudioCollecter();
        if (this.mCollectSampleRate <= 0 && this.mPlaySampleRate > 0) {
            this.mCollectSampleRate = this.mPlaySampleRate;
        }
        if (this.mCollectChannels <= 0 && this.mPlayChannels > 0) {
            this.mCollectChannels = this.mPlayChannels;
        }
        this.mAudioCollecter.config(this.mCollectSampleRate, this.mCollectChannels, this.mCollectBitrate);
    }

    private void releaseAudioCollecter() {
        if (this.mAudioCollecter != null) {
            this.mAudioCollecter.stop();
            this.mAudioCollecter = null;
            ZJLog.d((String)"Audio collecter is released");
        }
        this.mCollectSampleRate = 0;
        this.mCollectChannels = 0;
        this.isCollectAAC = true;
    }

    public void configCollect(int sampleRate, int channels, int bitrate) {
        this.mCollectSampleRate = sampleRate;
        this.mCollectChannels = channels;
        this.mCollectBitrate = bitrate;
    }

    public void setOnAudioRecordListener(ZJAudioCollecter.OnAudioRecordListener onAudioRecordListener) {
        this.initAudioCollecter();
        this.mAudioCollecter.setOnAudioRecordListener(onAudioRecordListener);
    }

    private int startCollect() {
        int sessionId = -1;
        if (!this.mAecEnable && this.mCollectSampleRate <= 0) {
            return sessionId;
        }
        this.configAudioCollecter();
        this.setEnableAec(this.mAecEnable);
        if (this.isCollectAAC) {
            this.mAudioCollecter.start();
        } else {
            this.mAudioCollecter.startPCM();
        }
        sessionId = this.mAudioCollecter.getSessionId();
        return sessionId;
    }

    public void stopCollect() {
        this.releaseAudioCollecter();
    }

    public void setEnableAec(boolean enable) {
        this.mAecEnable = enable;
        this.initAudioCollecter();
        this.mAudioCollecter.setEnableAec(enable);
    }
}

