/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer.Audio;

import android.content.Context;
import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.audiofx.AcousticEchoCanceler;
import android.util.Log;
import com.eafy.zjlog.ZJLog;
import com.eafy.zjmediaplayer.utils.PermissionUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZJAudioCollecter
implements Runnable {
    private static final String TAG = "AudioCollecter";
    private static ZJAudioCollecter instance;
    private Context mContext = null;
    private String MIME_TYPE = "audio/mp4a-latm";
    private int mSamplerate = 44100;
    private int mBitrate = 128000;
    private int mChannel = 16;
    private int mFormat = 2;
    private int mSamplesPerFrame = 1024;
    private boolean isAAC = true;
    private AudioRecord mAudioRecoder;
    private MediaCodec mAudioEncoder;
    private Thread thread;
    private boolean isRun = false;
    private int mBufferSize = 0;
    private AcousticEchoCanceler mAcousticEchoCanceler = null;
    private boolean mAecEnable = false;
    private OnAudioRecordListener onAudioRecordListener = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZJAudioCollecter shared() {
        if (instance != null) return instance;
        Class<ZJAudioCollecter> clazz = ZJAudioCollecter.class;
        synchronized (ZJAudioCollecter.class) {
            if (instance != null) return instance;
            instance = new ZJAudioCollecter(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ZJAudioCollecter(Context context) {
        this.mContext = context;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    private void initAudioCodec() {
        if (this.mAudioRecoder != null || this.mSamplerate < 0) {
            return;
        }
        int minBufferSize = AudioRecord.getMinBufferSize((int)this.mSamplerate, (int)this.mChannel, (int)this.mFormat);
        this.mBufferSize = this.mSamplesPerFrame * 10;
        if (this.isAAC) {
            if (this.mBufferSize < minBufferSize) {
                this.mBufferSize = (minBufferSize / this.mSamplesPerFrame + 1) * this.mSamplesPerFrame * 2;
            }
        } else {
            int n = this.mBufferSize = minBufferSize > 320 ? 320 : minBufferSize;
        }
        if (this.isAAC) {
            MediaFormat audioFormat = new MediaFormat();
            audioFormat.setString("mime", this.MIME_TYPE);
            audioFormat.setInteger("aac-profile", 2);
            audioFormat.setInteger("sample-rate", this.mSamplerate);
            audioFormat.setInteger("channel-count", 1);
            audioFormat.setInteger("bitrate", this.mBitrate);
            audioFormat.setInteger("max-input-size", 16384);
            try {
                this.mAudioEncoder = MediaCodec.createEncoderByType((String)this.MIME_TYPE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.mAudioEncoder.configure(audioFormat, null, null, 1);
            this.mAudioEncoder.start();
        }
        this.mAudioRecoder = new AudioRecord(1, this.mSamplerate, this.mChannel, this.mFormat, this.mBufferSize);
        if (this.mAecEnable) {
            this.initAec();
            this.setEnableAec(this.mAecEnable);
        }
        this.mAudioRecoder.startRecording();
    }

    private void relaseAudioCodec() {
        if (this.mAudioRecoder != null) {
            this.mAudioRecoder.stop();
            this.mAudioRecoder.release();
            this.mAudioRecoder = null;
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.stop();
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
        }
        if (this.mAcousticEchoCanceler != null) {
            this.mAcousticEchoCanceler.release();
            this.mAcousticEchoCanceler = null;
        }
    }

    public void config(int sampleRate, int channels, int bitrate) {
        this.mSamplerate = sampleRate;
        this.mChannel = channels == 1 ? 16 : 12;
        if (this.mBitrate > 0) {
            this.mBitrate = bitrate;
        }
    }

    public void start() {
        if (this.thread != null || this.mSamplerate <= 0 || this.mChannel <= 0) {
            return;
        }
        if (this.mContext != null && !PermissionUtils.checkPermission(this.mContext, "android.permission.RECORD_AUDIO")) {
            ZJLog.e((String)"Audio collecter no record permission");
            return;
        }
        this.isRun = true;
        this.initAudioCodec();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void startPCM() {
        this.isAAC = false;
        this.start();
    }

    public void stop() {
        this.isRun = false;
        this.isAAC = false;
        if (this.thread != null) {
            try {
                this.thread.join();
                this.thread = null;
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)("Stop collecter error:" + e.getLocalizedMessage()));
            }
        }
        this.relaseAudioCodec();
    }

    public boolean isCollecting() {
        return this.isRun;
    }

    public int getSessionId() {
        if (this.mAudioRecoder == null) {
            return -1;
        }
        return this.mAudioRecoder.getAudioSessionId();
    }

    private void addADTStoPacket(byte[] packet, int packetLen) {
        int profile = 2;
        int freqIdx = 4;
        int chanCfg = 1;
        packet[0] = -1;
        packet[1] = -7;
        packet[2] = (byte)((profile - 1 << 6) + (freqIdx << 2) + (chanCfg >> 2));
        packet[3] = (byte)(((chanCfg & 3) << 6) + (packetLen >> 11));
        packet[4] = (byte)((packetLen & 0x7FF) >> 3);
        packet[5] = (byte)(((packetLen & 7) << 5) + 31);
        packet[6] = -4;
    }

    @Override
    public void run() {
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        byte[] buffer = new byte[this.mBufferSize];
        block2: while (this.isRun && this.mAudioRecoder != null) {
            if (!this.isAAC) {
                this.mAudioRecoder.read(buffer, 0, this.mBufferSize);
                if (this.onAudioRecordListener == null) continue;
                this.onAudioRecordListener.onVoiceRecord(buffer, System.nanoTime() / 1000L);
                continue;
            }
            ByteBuffer[] inputBuffers = this.mAudioEncoder.getInputBuffers();
            int inputBufferIndex = this.mAudioEncoder.dequeueInputBuffer(-1L);
            if (inputBufferIndex < 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
            inputBuffer.clear();
            int inputLength = this.mAudioRecoder.read(inputBuffer, this.mSamplesPerFrame * 2);
            if (inputLength == -2 || inputLength == -3) {
                Log.e((String)TAG, (String)"Audio read error!!!");
            }
            this.mAudioEncoder.queueInputBuffer(inputBufferIndex, 0, inputLength, System.nanoTime() / 1000L, 0);
            ByteBuffer[] outputBuffers = this.mAudioEncoder.getOutputBuffers();
            while (true) {
                int TIMEOUT_USEC = 100;
                int encoderStatus = this.mAudioEncoder.dequeueOutputBuffer(bufferInfo, 100L);
                if (encoderStatus == -1) continue block2;
                if (encoderStatus == -3) {
                    outputBuffers = this.mAudioEncoder.getOutputBuffers();
                    continue;
                }
                if (encoderStatus == -2) {
                    MediaFormat mediaFormat = this.mAudioEncoder.getOutputFormat();
                    continue;
                }
                if (encoderStatus < 0) {
                    Log.e((String)TAG, (String)("encoder.dequeueOutputBuffer: " + encoderStatus));
                    continue;
                }
                ByteBuffer encodedData = outputBuffers[encoderStatus];
                if (encodedData == null) {
                    throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                }
                if ((bufferInfo.flags & 2) != 0) {
                    bufferInfo.size = 0;
                }
                if (bufferInfo.size != 0 && this.isRun) {
                    encodedData.position(bufferInfo.offset);
                    encodedData.limit(bufferInfo.offset + bufferInfo.size);
                    if (this.onAudioRecordListener != null) {
                        byte[] aacBuf = new byte[bufferInfo.size];
                        encodedData.get(aacBuf);
                        this.onAudioRecordListener.onVoiceRecord(aacBuf, bufferInfo.presentationTimeUs);
                    }
                }
                this.mAudioEncoder.releaseOutputBuffer(encoderStatus, false);
            }
        }
    }

    public OnAudioRecordListener getOnAudioRecordListener() {
        return this.onAudioRecordListener;
    }

    public void setOnAudioRecordListener(OnAudioRecordListener onAudioRecordListener) {
        this.onAudioRecordListener = onAudioRecordListener;
    }

    private void initAec() {
        if (!AcousticEchoCanceler.isAvailable()) {
            ZJLog.e((String)"Not support auido AEC");
            return;
        }
        if (this.getSessionId() < 0) {
            ZJLog.e((String)"No init auido record");
            return;
        }
        this.mAcousticEchoCanceler = AcousticEchoCanceler.create((int)this.getSessionId());
        if (this.mAcousticEchoCanceler == null) {
            ZJLog.e((String)"AcousticEchoCanceler create failed");
            return;
        }
    }

    public boolean setEnableAec(boolean enable) {
        this.mAecEnable = enable;
        if (this.mAcousticEchoCanceler == null) {
            return false;
        }
        int ret = this.mAcousticEchoCanceler.setEnabled(enable);
        if (ret != 0) {
            ZJLog.e((String)"AcousticEchoCanceler set enabled failed");
            return false;
        }
        if (enable) {
            ZJLog.d((String)"Audio player AEC on");
        } else {
            ZJLog.d((String)"Audio player AEC off");
        }
        return true;
    }

    public static interface OnAudioRecordListener {
        public void onVoiceRecord(byte[] var1, long var2);
    }
}

