/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer.Audio;

import android.content.Context;
import com.eafy.zjmediaplayer.Audio.ZJAudioAECPlayer;
import com.eafy.zjmediaplayer.Audio.ZJAudioCollecter;
import com.eafy.zjmediaplayer.Audio.ZJAudioSessionManager;
import com.eafy.zjmediaplayer.Listener.ZJAudioRtmpTalkerListener;
import com.eafy.zjmediaplayer.ZJMediaPusherJni;
import com.eafy.zjmediaplayer.utils.PermissionUtils;

public class ZJAudioRtmpTalker {
    private Context mContext = null;
    private ZJAudioRtmpTalkerListener mTalkerListener = null;
    private ZJAudioAECPlayer mAecPlayer = null;
    private int mSampleRate = 44100;
    private int mChannels = 1;
    private long mPusherAdr = 0L;

    private ZJAudioAECPlayer getAecPlayer() {
        if (this.mAecPlayer != null) {
            return this.mAecPlayer;
        }
        this.mAecPlayer = new ZJAudioAECPlayer();
        return this.mAecPlayer;
    }

    public void setListener(ZJAudioRtmpTalkerListener listener) {
        this.mTalkerListener = listener;
    }

    public void config(ZJAudioAECPlayer player, int sampleRate, int channels) {
        this.mAecPlayer = player;
        this.mSampleRate = sampleRate;
        this.mChannels = channels;
    }

    public void startTalk(Context context, String url) {
        if (context == null || !PermissionUtils.checkPermission(context, "android.permission.RECORD_AUDIO")) {
            if (this.mTalkerListener != null) {
                this.mTalkerListener.didZJAudioRtmpTalkerStatus(5, 0);
            }
            return;
        }
        ZJAudioSessionManager.shared().changeMode(4);
        this.getAecPlayer();
        if (this.isTalking()) {
            ZJMediaPusherJni.StopTalk(this.mPusherAdr);
        }
        if (this.mPusherAdr == 0L) {
            this.mPusherAdr = ZJMediaPusherJni.Init();
            ZJMediaPusherJni.SetListener(this.mPusherAdr, new ZJAudioRtmpTalkerListener(){

                @Override
                public void didZJAudioRtmpTalkerStatus(int status, int errCode) {
                    if (ZJAudioRtmpTalker.this.mTalkerListener != null) {
                        ZJAudioRtmpTalker.this.mTalkerListener.didZJAudioRtmpTalkerStatus(status, errCode);
                    }
                }
            });
        }
        if (ZJMediaPusherJni.StartTalk(this.mPusherAdr, url, this.mSampleRate, this.mChannels, 128000) == 0) {
            this.mAecPlayer.configCollect(this.mSampleRate, this.mChannels, 128000);
            this.mAecPlayer.setOnAudioRecordListener(new ZJAudioCollecter.OnAudioRecordListener(){

                @Override
                public void onVoiceRecord(byte[] data, long ts) {
                    ZJMediaPusherJni.SendAudioData(ZJAudioRtmpTalker.this.mPusherAdr, data);
                }
            });
            this.mAecPlayer.isCollectAAC = true;
            this.mAecPlayer.start();
            if (this.mTalkerListener != null) {
                this.mTalkerListener.didZJAudioRtmpTalkerStatus(2, 0);
            }
        } else if (this.mTalkerListener != null) {
            this.mTalkerListener.didZJAudioRtmpTalkerStatus(4, 0);
        }
    }

    public void stopTalk() {
        if (this.mAecPlayer != null) {
            this.mAecPlayer.setOnAudioRecordListener(null);
            this.mAecPlayer.stopCollect();
            this.mAecPlayer = null;
            ZJMediaPusherJni.Release(this.mPusherAdr);
            this.mPusherAdr = 0L;
        }
    }

    public boolean isTalking() {
        return ZJMediaPusherJni.IsTalking(this.mPusherAdr);
    }
}

