/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer.Audio;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.util.Log;
import com.eafy.zjlog.ZJLog;
import com.eafy.zjmediaplayer.utils.PermissionUtils;

public class ZJAudioSessionManager {
    private static ZJAudioSessionManager mInstance = null;
    private Context mContext = null;
    private int lastModel = -100;
    private int sessionModel = 2;
    private AudioManager.OnAudioFocusChangeListener afChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            if (focusChange == -2 || focusChange == -1 || focusChange == -3 || focusChange == 1) {
                // empty if block
            }
        }
    };

    public static synchronized ZJAudioSessionManager shared() {
        if (mInstance == null) {
            mInstance = new ZJAudioSessionManager();
        }
        return mInstance;
    }

    public void setContext(Context context) {
        if (context == null) {
            return;
        }
        this.mContext = context.getApplicationContext();
        this.getModel();
    }

    public Context getContext() {
        return this.mContext;
    }

    @SuppressLint(value={"WrongConstant"})
    public int getModel() {
        if (this.mContext == null) {
            return 0;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int mode = audioManager.getMode();
        if (this.lastModel == -100) {
            this.lastModel = audioManager.getMode();
            Log.d((String)"ZJMediaPlayer", (String)("Audio session current mode:" + mode));
        }
        return mode;
    }

    public void changeMode(int mode) {
        if (this.mContext == null) {
            return;
        }
        if (!PermissionUtils.checkPermission(this.mContext, "android.permission.MODIFY_AUDIO_SETTINGS")) {
            ZJLog.e((String)"No audio settings permission");
            return;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.adjustSilentVolume(mode);
        switch (mode) {
            case 1: {
                audioManager.setMode(0);
                break;
            }
            case 2: 
            case 5: {
                audioManager.setMode(0);
                audioManager.stopBluetoothSco();
                audioManager.setBluetoothScoOn(false);
                audioManager.setSpeakerphoneOn(true);
                break;
            }
            case 3: {
                audioManager.setMode(3);
                audioManager.setSpeakerphoneOn(false);
                break;
            }
            case 4: {
                audioManager.setMode(3);
                audioManager.setSpeakerphoneOn(true);
                break;
            }
            case 6: {
                audioManager.setMode(3);
                audioManager.startBluetoothSco();
                audioManager.setBluetoothScoOn(true);
                audioManager.setSpeakerphoneOn(false);
                break;
            }
        }
        this.sessionModel = mode;
    }

    public void adjustSilentVolume(int mode) {
        if (this.mContext == null) {
            return;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int streamType = 3;
        int volume = -1;
        switch (mode) {
            case 0: {
                volume = 0;
                break;
            }
            case 1: {
                streamType = 0;
                break;
            }
            case 2: 
            case 5: {
                streamType = 3;
                break;
            }
            case 3: {
                streamType = 3;
                break;
            }
            case 4: 
            case 6: {
                streamType = 3;
                break;
            }
        }
        if (volume < 0 && (volume = audioManager.getStreamVolume(streamType)) == 0) {
            int maxVolume = audioManager.getStreamMaxVolume(streamType);
            volume = (int)((double)maxVolume * 0.5);
        }
        audioManager.setStreamVolume(streamType, volume, 4);
    }

    public boolean isWiredHeadsetOn() {
        if (this.mContext == null) {
            return false;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        return audioManager.isWiredHeadsetOn();
    }

    public boolean isBluetoothA2dpOn() {
        if (this.mContext == null) {
            return false;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        return audioManager.isBluetoothA2dpOn();
    }

    public boolean isSpeakerphoneOn() {
        if (this.mContext == null) {
            return true;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        return audioManager.isSpeakerphoneOn();
    }

    public void pauseMusic(AudioManager.OnAudioFocusChangeListener focusRequest) {
        if (this.mContext == null || focusRequest == null) {
            return;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        audioManager.requestAudioFocus(focusRequest, 3, 1);
    }

    @SuppressLint(value={"WrongConstant"})
    public void dispose(AudioManager.OnAudioFocusChangeListener focusRequest) {
        if (this.mContext == null) {
            return;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        if (this.lastModel != -100) {
            audioManager.setMode(this.lastModel);
        }
        this.lastModel = -100;
        if (audioManager.isBluetoothScoOn()) {
            audioManager.setBluetoothScoOn(false);
            audioManager.stopBluetoothSco();
        }
        audioManager.unloadSoundEffects();
        if (null != focusRequest) {
            audioManager.abandonAudioFocus(focusRequest);
        }
    }

    public void raiseVolume() {
        if (this.mContext == null) {
            return;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int currentVolume = audioManager.getStreamVolume(3);
        if (currentVolume < audioManager.getStreamMaxVolume(3)) {
            audioManager.adjustStreamVolume(3, 1, 1);
        }
    }

    public void lowerVolume() {
        if (this.mContext == null) {
            return;
        }
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int currentVolume = audioManager.getStreamVolume(3);
        if (currentVolume > 0) {
            audioManager.adjustStreamVolume(3, -1, 1);
        }
    }
}

