/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer.Listener;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import com.eafy.zjmediaplayer.Audio.ZJAudioSessionManager;

public class HeadsetPlugReceiver
extends BroadcastReceiver {
    private static final String TAG = "HeadsetPlugReceiver";
    private AudioManager audioManager;

    public void onReceive(Context context, Intent intent) {
        if (ZJAudioSessionManager.shared().getContext() == null) {
            ZJAudioSessionManager.shared().setContext(context);
        }
        this.audioManager = (AudioManager)context.getSystemService("audio");
        String action = intent.getAction();
        if (action.equals("android.intent.action.HEADSET_PLUG")) {
            int state = intent.getIntExtra("state", 0);
            if (state == 0) {
                ZJAudioSessionManager.shared().changeMode(2);
            } else if (state == 1) {
                ZJAudioSessionManager.shared().changeMode(3);
            }
        } else if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
            int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
            this.updateBluetoothIndication(state);
        } else if ("android.media.AUDIO_BECOMING_NOISY".equals(action)) {
            ZJAudioSessionManager.shared().changeMode(2);
        }
    }

    public void updateBluetoothIndication(int bluetoothHeadsetState) {
        if (bluetoothHeadsetState == 2) {
            if (this.audioManager == null) {
                return;
            }
            ZJAudioSessionManager.shared().changeMode(6);
        } else {
            if (this.audioManager == null) {
                return;
            }
            ZJAudioSessionManager.shared().changeMode(2);
        }
    }
}

