/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer.Video;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.PixelCopy;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.NonNull;
import com.eafy.zjlog.ZJLog;
import com.eafy.zjmediaplayer.Listener.ZJGLMonitorListener;
import com.eafy.zjmediaplayer.ZJMediaStreamPlayerJni;

public class ZJGLMonitor
extends SurfaceView
implements SurfaceHolder.Callback {
    private SurfaceHolder mSurfaceHolder = null;
    private int mFormat = 0;
    private int mWidth = 0;
    private int mHeight = 0;
    private boolean bActive = false;
    private long mPlayerAddr = 0L;
    private SurfaceHolder.Callback mSurfaceCB = null;
    private ZJGLMonitorListener mlistener = null;

    public ZJGLMonitor(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public ZJGLMonitor(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public ZJGLMonitor(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public ZJGLMonitor(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void surfaceCreated(@NonNull SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        if (this.mSurfaceCB == null) {
            return;
        }
        this.mSurfaceCB.surfaceCreated(holder);
    }

    public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
        this.mFormat = format;
        this.mWidth = width;
        this.mHeight = height;
        if (this.mSurfaceCB == null) {
            return;
        }
        ZJLog.d((String)("SurfaceHolder changed width:" + width + ", height" + height));
    }

    public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
        this.mPlayerAddr = 0L;
        if (this.mSurfaceCB == null) {
            return;
        }
        this.mSurfaceCB.surfaceDestroyed(holder);
    }

    private void setPlayerAddress(long mPlayerAddr) {
        this.mPlayerAddr = mPlayerAddr;
    }

    private void receiveYUV420pData(byte[] dataY, byte[] dataU, byte[] dataV, int width, int height) {
        if (this.mlistener == null) {
            return;
        }
        if (width > 0 && height > 0 && dataY != null && dataU != null && dataV != null) {
            int frameSize = width * height;
            int[] rgba = new int[frameSize];
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int y = 0xFF & dataY[i * width + j];
                    int u = 0xFF & dataU[i / 2 * (width / 2) + j / 2];
                    int v = 0xFF & dataV[i / 2 * (width / 2) + j / 2];
                    y = y < 16 ? 16 : y;
                    int r = (int)((double)y + 1.732446 * (double)(u - 128));
                    int g = (int)((double)y - 0.698001 * (double)(u - 128) - 0.703125 * (double)(v - 128));
                    int b = (int)((double)y + 1.370705 * (double)(v - 128));
                    int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                    int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                    b = b < 0 ? 0 : (b > 255 ? 255 : b);
                    rgba[i * width + j] = -16777216 + (b << 16) + (g << 8) + r;
                }
            }
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bmp.setPixels(rgba, 0, width, 0, 0, width, height);
            this.mlistener.didSnapshot(this, bmp);
        } else {
            this.mlistener.didSnapshot(this, null);
        }
    }

    public void configListener(SurfaceHolder.Callback lisenter) {
        this.mSurfaceCB = lisenter;
        if (this.mSurfaceCB != null) {
            if (this.mSurfaceHolder == null) {
                return;
            }
            this.mSurfaceCB.surfaceCreated(this.mSurfaceHolder);
            this.mSurfaceCB.surfaceChanged(this.mSurfaceHolder, this.mFormat, this.mWidth, this.mHeight);
        } else {
            this.mPlayerAddr = 0L;
        }
    }

    public void onResume() {
        ZJMediaStreamPlayerJni.SetSurfaceStop(this.mPlayerAddr, false);
    }

    public void onPause() {
        ZJMediaStreamPlayerJni.SetSurfaceStop(this.mPlayerAddr, true);
    }

    public void displayRatioType(int type) {
        ZJMediaStreamPlayerJni.SetRatioType(this.mPlayerAddr, this, type);
    }

    public void image(ZJGLMonitorListener listener) {
        this.mlistener = listener;
        if (listener == null) {
            return;
        }
        ZJMediaStreamPlayerJni.SurfaceSnapshot(this.mPlayerAddr, this);
    }

    public void snapshot(ZJGLMonitorListener listener) {
        if (Build.VERSION.SDK_INT >= 24) {
            Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            HandlerThread handlerThread = new HandlerThread("PixelCopier");
            handlerThread.start();
            PixelCopy.request((SurfaceView)this, (Bitmap)bitmap, copyResult -> {
                if (copyResult == 0) {
                    listener.didSnapshot(this, bitmap);
                } else {
                    listener.didSnapshot(this, null);
                }
                handlerThread.quitSafely();
            }, (Handler)new Handler(handlerThread.getLooper()));
        } else {
            this.image(listener);
        }
    }

    public void displayBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            int size = width * height;
            int[] pixels = new int[size];
            bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
            int len = width * height;
            byte[] dataY = new byte[len];
            byte[] dataU = new byte[len / 4];
            byte[] dataV = new byte[len / 4];
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int rgb = pixels[i * width + j] & 0xFFFFFF;
                    int r = rgb & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb >> 16 & 0xFF;
                    int y = (66 * r + 129 * g + 25 * b + 128 >> 8) + 16;
                    int u = (112 * r - 94 * g - 18 * b + 128 >> 8) + 128;
                    int v = (-38 * r - 74 * g + 112 * b + 128 >> 8) + 128;
                    int n = y < 16 ? 16 : (y = y > 255 ? 255 : y);
                    int n2 = u < 0 ? 0 : (u = u > 255 ? 255 : u);
                    v = v < 0 ? 0 : (v > 255 ? 255 : v);
                    dataY[i * width + j] = (byte)y;
                    dataU[i / 2 * (width / 2) + j / 2] = (byte)u;
                    dataV[i / 2 * (width / 2) + j / 2] = (byte)v;
                }
            }
            ZJMediaStreamPlayerJni.DisplayBitmap(this.mPlayerAddr, this, width, height, dataY, dataU, dataV);
        }
    }
}

