/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import com.eafy.zjlog.ZJLog;

public class ZJAuthManager {
    private static ZJAuthManager mInstance;
    private Context mContext = null;

    public static synchronized ZJAuthManager shared() {
        if (mInstance == null) {
            mInstance = new ZJAuthManager();
        }
        return mInstance;
    }

    public boolean isDebugMode() {
        if (this.mContext == null) {
            return false;
        }
        boolean isDebug = false;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            ApplicationInfo appinfo = pm.getApplicationInfo(this.mContext.getPackageName(), 0);
            isDebug = 0 != (appinfo.flags & 2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return isDebug;
    }

    public boolean config(Context context, String key, String secret) {
        this.mContext = context;
        return ZJAuthManager.jniConfig(key, secret);
    }

    public void openDebugMode() {
        ZJAuthManager.jniOpenDebugMode(this);
    }

    public boolean isAuthOK() {
        return ZJAuthManager.jniIsAuthOK(this);
    }

    public static native boolean jniConfig(String var0, String var1);

    public static native void jniOpenDebugMode(ZJAuthManager var0);

    public static native boolean jniIsAuthOK(ZJAuthManager var0);

    static {
        try {
            System.loadLibrary("ZJMediaPlayer");
        }
        catch (UnsatisfiedLinkError ule) {
            ZJLog.d((String)ule.getMessage());
        }
        mInstance = null;
    }
}

