/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer;

import android.content.Context;
import com.eafy.zjmediaplayer.ZJMediaStreamPlayer;
import com.eafy.zjmediaplayer.ZJMediaStreamPlayerJni;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ZJMediaPlayer
extends ZJMediaStreamPlayer {
    private boolean m_bSniffAll = true;
    private Map<String, String> optFormatDic = null;
    public int preCacheDuration = 0;

    public ZJMediaPlayer(Context context) {
        super(context);
    }

    public void config(int type, String name, String value) {
        if (type == 0) {
            if (name == null || name.length() == 0) {
                if (this.optFormatDic != null) {
                    this.optFormatDic.clear();
                }
            } else {
                if (this.optFormatDic == null) {
                    this.optFormatDic = new HashMap<String, String>();
                }
                this.optFormatDic.put(name, value);
            }
        }
    }

    public void startURL(String url) {
        if (url != null) {
            this.url = url;
        }
        if (this.url == null) {
            return;
        }
        File f = new File(url);
        boolean isFile = f.exists();
        if (!isFile) {
            ZJMediaStreamPlayerJni.SetPreCacheDuration(this.mPlayerAddr, this.preCacheDuration);
            if (this.optFormatDic != null) {
                if (this.optFormatDic.size() > 0) {
                    for (Map.Entry<String, String> entry : this.optFormatDic.entrySet()) {
                        ZJMediaStreamPlayerJni.SetOptFormtParam(this.mPlayerAddr, 0, entry.getKey(), entry.getValue());
                    }
                } else {
                    ZJMediaStreamPlayerJni.SetOptFormtParam(this.mPlayerAddr, 0, "", "");
                }
            }
        }
        this.setSniffAllEnable(this.m_bSniffAll);
        ZJMediaStreamPlayerJni.StartURL(this.mPlayerAddr, url, isFile);
    }

    public boolean restart() {
        if (this.url == null) {
            return false;
        }
        this.startURL(this.url);
        return true;
    }

    public void pause() {
        ZJMediaStreamPlayerJni.Pause(this.mPlayerAddr);
    }

    public void resume() {
        ZJMediaStreamPlayerJni.Resume(this.mPlayerAddr);
    }

    public boolean seek(int msTime) {
        return ZJMediaStreamPlayerJni.Seek(this.mPlayerAddr, msTime);
    }

    public void setSniffAllEnable(boolean bSniffAll) {
        this.m_bSniffAll = bSniffAll;
        ZJMediaStreamPlayerJni.SetSniffAllEnable(this.mPlayerAddr, bSniffAll);
    }
}

