/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer;

import android.content.Context;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import com.eafy.zjlog.ZJLog;
import com.eafy.zjmediaplayer.Audio.ZJAudioAECPlayer;
import com.eafy.zjmediaplayer.Audio.ZJAudioCollecter;
import com.eafy.zjmediaplayer.Audio.ZJAudioSessionManager;
import com.eafy.zjmediaplayer.Listener.ZJMediaPlayerHandleAudioDataListener;
import com.eafy.zjmediaplayer.Listener.ZJMediaPlayerHandleVideoDataListener;
import com.eafy.zjmediaplayer.Listener.ZJMediaPlayerListener;
import com.eafy.zjmediaplayer.Video.ZJGLMonitor;
import com.eafy.zjmediaplayer.ZJMediaStatisticalInfo;
import com.eafy.zjmediaplayer.ZJMediaStreamConfig;
import com.eafy.zjmediaplayer.ZJMediaStreamPlayerJni;
import com.eafy.zjmediaplayer.utils.AppStateHelper;
import com.eafy.zjmediaplayer.utils.PermissionUtils;
import java.io.File;

public class ZJMediaStreamPlayer {
    private ZJGLMonitor mGLMonitor = null;
    protected Context mContext = null;
    protected long mPlayerAddr = 0L;
    private boolean isRecordCollect = false;
    private Boolean isSpeakerMode = null;
    private boolean isCallMode = false;
    protected ZJMediaPlayerListener mPlayerListener = null;
    protected int mPlayStatus = 0;
    protected ZJMediaPlayerHandleAudioDataListener mAudioDataListener = null;
    protected ZJMediaPlayerHandleVideoDataListener mVideoDataListener = null;
    private ZJAudioAECPlayer mAudioAECPlayer = null;
    private boolean mMute = false;
    private int seiInfoType = 0;
    public Object userInfo = null;
    public String url = "";
    private ZJMediaPlayerListener mPrivatePlayerListener = new ZJMediaPlayerListener(){

        @Override
        public void didMediaPlayerPlay(ZJMediaStreamPlayer player, int status, int errCode) {
            ZJMediaStreamPlayer.this.mPlayStatus = status;
            if (status == 1) {
                ZJMediaStreamPlayer.this.configAudioPlayer();
            }
            if (ZJMediaStreamPlayer.this.mPlayerListener != null) {
                ZJMediaStreamPlayer.this.mPlayerListener.didMediaPlayerPlay(player, status, errCode);
            }
        }

        @Override
        public void didMediaPlayerStatisticalInfo(ZJMediaStreamPlayer player, ZJMediaStatisticalInfo statInfo) {
            if (ZJMediaStreamPlayer.this.mPlayerListener != null) {
                ZJMediaStreamPlayer.this.mPlayerListener.didMediaPlayerStatisticalInfo(player, statInfo);
            }
        }

        @Override
        public void didMediaPlayerRecord(ZJMediaStreamPlayer player, int status, String filePath, int errCode) {
            if (ZJMediaStreamPlayer.this.mPlayerListener != null) {
                ZJMediaStreamPlayer.this.mPlayerListener.didMediaPlayerRecord(player, status, filePath, errCode);
            }
        }

        @Override
        public void didMediaPlayerRecvSeiInfo(ZJMediaStreamPlayer player, byte[] data) {
            if (ZJMediaStreamPlayer.this.mPlayerListener != null && ZJMediaStreamPlayer.this.seiInfoType > 0 && ZJMediaStreamPlayer.this.seiInfoType == 1) {
                ZJMediaStreamPlayer.this.mPlayerListener.didMediaPlayerRecvSeiInfo(player, data);
            }
        }
    };

    public ZJMediaStreamPlayer(Context context) {
        this.mContext = context;
        this.mPlayerAddr = ZJMediaStreamPlayerJni.InitStreamPlayer();
        ZJAudioSessionManager.shared().setContext(context);
        ZJLog.d((String)("Media Player[" + this + "], Address:" + this.mPlayerAddr));
    }

    public void release() {
        if (this.mPlayerAddr == 0L) {
            return;
        }
        this.mPlayerListener = null;
        this.mAudioDataListener = null;
        this.mVideoDataListener = null;
        ZJMediaStreamPlayerJni.SetListener(this, this.mPlayerAddr, null);
        this.stopRecord();
        this.stop();
        this.removeMonitor();
        ZJMediaStreamPlayerJni.Release(this.mPlayerAddr);
        this.releaseAudioPlayer();
        this.mPlayerAddr = 0L;
    }

    public void setListener(ZJMediaPlayerListener listener) {
        this.mPlayerListener = listener;
        ZJMediaStreamPlayerJni.SetListener(this, this.mPlayerAddr, listener != null ? this.mPrivatePlayerListener : null);
    }

    public void setAudioDataListener(ZJMediaPlayerHandleAudioDataListener listener) {
        this.mAudioDataListener = listener;
    }

    public void setVideoDataListener(ZJMediaPlayerHandleVideoDataListener listener) {
        this.mVideoDataListener = listener;
        ZJMediaStreamPlayerJni.SetVideoDataListener(this, this.mPlayerAddr, listener);
    }

    public void addMonitor(ZJGLMonitor monitor) {
        if (monitor == null) {
            return;
        }
        this.mGLMonitor = monitor;
        monitor.configListener(new SurfaceHolder.Callback(){

            public void surfaceCreated(@NonNull SurfaceHolder holder) {
                ZJMediaStreamPlayerJni.SetSurface(ZJMediaStreamPlayer.this.mPlayerAddr, ZJMediaStreamPlayer.this.mGLMonitor, holder.getSurface());
            }

            public void surfaceChanged(@NonNull SurfaceHolder holder, int format, int width, int height) {
                ZJMediaStreamPlayerJni.UpdateSurface(ZJMediaStreamPlayer.this.mPlayerAddr, holder.getSurface(), format, width, height);
            }

            public void surfaceDestroyed(@NonNull SurfaceHolder holder) {
                ZJMediaStreamPlayerJni.SetSurface(ZJMediaStreamPlayer.this.mPlayerAddr, ZJMediaStreamPlayer.this.mGLMonitor, null);
            }
        });
    }

    public void removeMonitor() {
        if (this.mGLMonitor == null) {
            return;
        }
        ZJMediaStreamPlayerJni.SetSurface(this.mPlayerAddr, this.mGLMonitor, null);
        this.mGLMonitor.configListener(null);
        this.mGLMonitor = null;
    }

    public ZJGLMonitor getMonitor() {
        return this.mGLMonitor;
    }

    public ZJMediaPlayerListener getListener() {
        return this.mPlayerListener;
    }

    public void setMute(boolean mute) {
        this.mMute = mute;
        if (this.mAudioAECPlayer != null) {
            this.mAudioAECPlayer.mMute = mute;
        }
    }

    public boolean getMute() {
        return this.mMute;
    }

    public void SetBackGroundState(boolean isBG) {
        ZJMediaStreamPlayerJni.SetBackGroundState(this.mPlayerAddr, isBG);
    }

    public void config(ZJMediaStreamConfig config) {
        ZJMediaStreamPlayerJni.Config(this.mPlayerAddr, config);
    }

    public boolean start() {
        return ZJMediaStreamPlayerJni.Start(this.mPlayerAddr);
    }

    public void stop() {
        ZJMediaStreamPlayerJni.Stop(this.mPlayerAddr);
        this.resetAudioPlayer();
    }

    public void openVideo() {
        ZJMediaStreamPlayerJni.OpenVideo(this.mPlayerAddr);
    }

    public void openAudio() {
        ZJMediaStreamPlayerJni.OpenAudio(this.mPlayerAddr);
    }

    public void closeVideo() {
        ZJMediaStreamPlayerJni.CloseVideo(this.mPlayerAddr);
    }

    public void closeAudio() {
        ZJMediaStreamPlayerJni.CloseAudio(this.mPlayerAddr);
    }

    public void playVideo(byte[] videoData, long ts) {
        ZJMediaStreamPlayerJni.PlayVideo(this.mPlayerAddr, videoData, ts);
    }

    public void playAudio(byte[] videoData, long ts) {
        ZJMediaStreamPlayerJni.PlayAudio(this.mPlayerAddr, videoData, ts);
    }

    public void clearVideoBuffer() {
        ZJMediaStreamPlayerJni.ClearVideoBuffer(this.mPlayerAddr);
    }

    public void clearAudioBuffer() {
        ZJMediaStreamPlayerJni.ClearAudioBuffer(this.mPlayerAddr);
    }

    public void setMediaCacheTime(double cacheTime, double pursueTime) {
        ZJMediaStreamPlayerJni.SetMediaCacheTime(this.mPlayerAddr, cacheTime, pursueTime);
    }

    public void setDenoiseLevel(int nLevel, double nGainVolume) {
        ZJMediaStreamPlayerJni.SetDenoiseLevel(this.mPlayerAddr, nLevel, nGainVolume);
    }

    public void setMediaSyncMode(boolean sync) {
        ZJMediaStreamPlayerJni.SetMediaSyncMode(this.mPlayerAddr, sync);
    }

    public void setSpeakerMode(Boolean val, boolean isCallMode) {
        if (this.mAudioAECPlayer != null) {
            this.mAudioAECPlayer.setSpeakerMode(val, isCallMode);
        } else {
            this.isSpeakerMode = val;
            this.isCallMode = isCallMode;
        }
    }

    public void setSeiInfoType(int type) {
        this.seiInfoType = type;
        ZJMediaStreamPlayerJni.SetSeiInfoType(this.mPlayerAddr, type);
    }

    public void startRecord(String filePath) {
        if (filePath == null) {
            return;
        }
        if (filePath.length() < 4) {
            return;
        }
        String prefix = filePath.substring(filePath.lastIndexOf(".") + 1);
        if (prefix.toUpperCase().equals("AMR") && this.isRecordCollect && !this.openAudioCollect()) {
            if (this.mPlayerListener != null) {
                this.mPlayerListener.didMediaPlayerRecord(this, 3, filePath, 8);
            }
            return;
        }
        File file = new File(filePath).getParentFile();
        if (!file.exists()) {
            file.mkdir();
        }
        ZJMediaStreamPlayerJni.StartRecord(this.mPlayerAddr, filePath, !this.isRecordCollect);
    }

    public void stopRecord() {
        if (this.isRecordCollect) {
            this.closeAudioCollect();
        }
        this.isRecordCollect = false;
        ZJMediaStreamPlayerJni.StopRecord(this.mPlayerAddr);
    }

    public boolean isRecording() {
        return ZJMediaStreamPlayerJni.IsRecording(this.mPlayerAddr);
    }

    public long getRecordDuration() {
        return ZJMediaStreamPlayerJni.GetRecordDuration(this.mPlayerAddr);
    }

    public void startRecordCollect(String filePath) {
        this.isRecordCollect = true;
        this.startRecord(filePath);
    }

    public ZJAudioAECPlayer getAudioPlayer() {
        if (this.mAudioAECPlayer == null) {
            this.mAudioAECPlayer = new ZJAudioAECPlayer();
            this.mAudioAECPlayer.setContext(this.mContext);
        }
        return this.mAudioAECPlayer;
    }

    private void configAudioPlayer() {
        this.getAudioPlayer();
        this.mAudioAECPlayer.mMute = this.mMute;
        this.mAudioAECPlayer.start();
        if (this.isSpeakerMode != null) {
            this.mAudioAECPlayer.setSpeakerMode(this.isSpeakerMode, this.isCallMode);
            this.isSpeakerMode = null;
        }
    }

    private void resetAudioPlayer() {
        if (this.mAudioAECPlayer == null) {
            return;
        }
        this.mAudioAECPlayer.stop();
    }

    private void releaseAudioPlayer() {
        this.resetAudioPlayer();
        this.mAudioAECPlayer = null;
    }

    private void loadMediaAudioData(byte[] audioData, int sampleRate, int channels) {
        if (!AppStateHelper.isForeground()) {
            return;
        }
        byte[] pAudioData = audioData;
        if (this.mAudioDataListener != null) {
            pAudioData = this.mAudioDataListener.didMediaPlayerHandleAudioData(this, audioData, sampleRate, channels);
        }
        if (pAudioData == null || pAudioData.length == 0) {
            return;
        }
        if (this.mAudioAECPlayer == null) {
            return;
        }
        this.mAudioAECPlayer.loadPcmData(pAudioData, sampleRate, channels);
    }

    private boolean openAudioCollect() {
        if (this.mContext == null || !PermissionUtils.checkPermission(this.mContext, "android.permission.RECORD_AUDIO")) {
            return false;
        }
        ZJAudioSessionManager.shared().changeMode(1);
        final ZJMediaStreamPlayer self = this;
        this.getAudioPlayer();
        this.mAudioAECPlayer.configCollect(8000, 1, 12200);
        this.mAudioAECPlayer.setOnAudioRecordListener(new ZJAudioCollecter.OnAudioRecordListener(){

            @Override
            public void onVoiceRecord(byte[] data, long ts) {
                byte[] pAudioData = data;
                if (ZJMediaStreamPlayer.this.mAudioDataListener != null) {
                    pAudioData = ZJMediaStreamPlayer.this.mAudioDataListener.didMediaPlayerHandleAudioData(self, data, 8000, 1);
                }
                if (pAudioData == null || pAudioData.length == 0) {
                    return;
                }
                ZJMediaStreamPlayerJni.RecordAudio(ZJMediaStreamPlayer.this.mPlayerAddr, pAudioData, 0L);
            }
        });
        this.mAudioAECPlayer.isCollectAAC = false;
        this.mAudioAECPlayer.start();
        return true;
    }

    private void closeAudioCollect() {
        if (this.mAudioAECPlayer == null) {
            return;
        }
        this.mAudioAECPlayer.setOnAudioRecordListener(null);
        this.mAudioAECPlayer.stopCollect();
    }
}

