/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer.utils;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

public class AppStateHelper {
    public static final int STATE_FOREGROUND = 0;
    public static final int STATE_BACKGROUND = 1;
    private static int currentState = 0;
    private static AppActivityLifecycleCallbacks appActivityLifecycleCallbacks = null;

    public static int getCurrentState() {
        return currentState;
    }

    public static boolean isForeground() {
        return currentState == 0;
    }

    public static void register(Application application, final AppStateChangeListener appStateChangeListener) {
        if (application == null) {
            return;
        }
        if (appActivityLifecycleCallbacks == null) {
            appActivityLifecycleCallbacks = new AppActivityLifecycleCallbacks(){
                private int resumeActivityCount = 0;

                @Override
                public void onActivityStarted(Activity activity) {
                    if (this.resumeActivityCount++ == 0) {
                        currentState = 0;
                        if (appStateChangeListener != null) {
                            appStateChangeListener.onAppIntoForeground();
                        }
                    }
                }

                @Override
                public void onActivityStopped(Activity activity) {
                    if (--this.resumeActivityCount == 0) {
                        currentState = 1;
                        if (appStateChangeListener != null) {
                            appStateChangeListener.onAppIntoBackGround();
                        }
                    }
                }
            };
        }
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)appActivityLifecycleCallbacks);
    }

    public static void unregister(Application application) {
        if (application == null || appActivityLifecycleCallbacks == null) {
            return;
        }
        application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)appActivityLifecycleCallbacks);
        appActivityLifecycleCallbacks = null;
    }

    private static class AppActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private AppActivityLifecycleCallbacks() {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }

    public static interface AppStateChangeListener {
        public void onAppIntoForeground();

        public void onAppIntoBackGround();
    }
}

