/*
 * Decompiled with CFR 0.152.
 */
package com.eafy.zjmediaplayer.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.List;

public class PermissionUtils {
    public static boolean checkPermission(Context context, String permission2) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static void checkPermission(Context context, String permission2, PermissionCheckCallBack callBack) {
        if (callBack == null) {
            return;
        }
        if (PermissionUtils.checkPermission(context, permission2)) {
            callBack.onHasPermission();
        } else if (PermissionUtils.judgePermission(context, permission2)) {
            callBack.onUserHasAlreadyTurnedDown(permission2);
        } else {
            callBack.onUserHasAlreadyTurnedDownAndDontAsk(permission2);
        }
    }

    public static List<String> checkMorePermissions(Context context, String[] permissions) {
        ArrayList<String> permissionList = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            if (PermissionUtils.checkPermission(context, permissions[i])) continue;
            permissionList.add(permissions[i]);
        }
        return permissionList;
    }

    public static void checkMorePermissions(Context context, String[] permissions, PermissionCheckCallBack callBack) {
        List<String> permissionList = PermissionUtils.checkMorePermissions(context, permissions);
        if (permissionList.size() == 0) {
            callBack.onHasPermission();
        } else {
            boolean isFirst = true;
            for (int i = 0; i < permissionList.size(); ++i) {
                String permission2 = permissionList.get(i);
                if (!PermissionUtils.judgePermission(context, permission2)) continue;
                isFirst = false;
                break;
            }
            String[] unauthorizedMorePermissions = permissionList.toArray(new String[permissionList.size()]);
            if (isFirst) {
                callBack.onUserHasAlreadyTurnedDownAndDontAsk(unauthorizedMorePermissions);
            } else {
                callBack.onUserHasAlreadyTurnedDown(unauthorizedMorePermissions);
            }
        }
    }

    public static void requestPermission(Context context, String permission2, int requestCode) {
        ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{permission2}, (int)requestCode);
    }

    public static void requestMorePermissions(Context context, List<String> permissionList, int requestCode) {
        String[] permissions = permissionList.toArray(new String[permissionList.size()]);
        PermissionUtils.requestMorePermissions(context, permissions, requestCode);
    }

    public static void requestMorePermissions(Context context, String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])permissions, (int)requestCode);
    }

    public static boolean judgePermission(Context context, String permission2) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)permission2);
    }

    public static void checkAndRequestPermission(Context context, String permission2, int requestCode) {
        if (!PermissionUtils.checkPermission(context, permission2)) {
            PermissionUtils.requestPermission(context, permission2, requestCode);
        }
    }

    public static void checkAndRequestPermission(Context context, String permission2, int requestCode, PermissionRequestSuccessCallBack callBack) {
        if (PermissionUtils.checkPermission(context, permission2)) {
            callBack.onHasPermission();
        } else {
            PermissionUtils.requestPermission(context, permission2, requestCode);
        }
    }

    public static void checkAndRequestMorePermissions(Context context, String[] permissions, int requestCode) {
        List<String> permissionList = PermissionUtils.checkMorePermissions(context, permissions);
        PermissionUtils.requestMorePermissions(context, permissionList, requestCode);
    }

    public static void checkAndRequestMorePermissions(Context context, String[] permissions, int requestCode, PermissionRequestSuccessCallBack callBack) {
        List<String> permissionList = PermissionUtils.checkMorePermissions(context, permissions);
        if (permissionList.size() == 0) {
            callBack.onHasPermission();
        } else {
            PermissionUtils.requestMorePermissions(context, permissionList, requestCode);
        }
    }

    public static boolean isPermissionRequestSuccess(int[] grantResults) {
        return grantResults.length > 0 && grantResults[0] == 0;
    }

    public static void onRequestPermissionResult(Context context, String permission2, int[] grantResults, PermissionCheckCallBack callback) {
        if (PermissionUtils.isPermissionRequestSuccess(grantResults)) {
            callback.onHasPermission();
        } else if (PermissionUtils.judgePermission(context, permission2)) {
            callback.onUserHasAlreadyTurnedDown(permission2);
        } else {
            callback.onUserHasAlreadyTurnedDownAndDontAsk(permission2);
        }
    }

    public static void onRequestMorePermissionsResult(Context context, String[] permissions, PermissionCheckCallBack callback) {
        boolean isBannedPermission = false;
        List<String> permissionList = PermissionUtils.checkMorePermissions(context, permissions);
        if (permissionList.size() == 0) {
            callback.onHasPermission();
        } else {
            for (int i = 0; i < permissionList.size(); ++i) {
                if (PermissionUtils.judgePermission(context, permissionList.get(i))) continue;
                isBannedPermission = true;
                break;
            }
            if (isBannedPermission) {
                callback.onUserHasAlreadyTurnedDownAndDontAsk(permissions);
            } else {
                callback.onUserHasAlreadyTurnedDown(permissions);
            }
        }
    }

    public static void toAppSetting(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static interface PermissionCheckCallBack {
        public void onHasPermission();

        public void onUserHasAlreadyTurnedDown(String ... var1);

        public void onUserHasAlreadyTurnedDownAndDontAsk(String ... var1);
    }

    public static interface PermissionRequestSuccessCallBack {
        public void onHasPermission();
    }
}

