/*
 * Decompiled with CFR 0.152.
 */
package com.github.desensitization;

import com.github.Symbol;
import com.github.desensitization.StringDesensitization;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailDesensitization
implements StringDesensitization {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("([A-Za-z0-9_\\-.])+@([A-Za-z0-9_\\-.])+\\.([A-Za-z]{2,4})");

    @Override
    public String desensitize(String target) {
        Matcher matcher = DEFAULT_PATTERN.matcher(target);
        while (matcher.find()) {
            String group = matcher.group();
            int l = group.lastIndexOf("@");
            target = target.replace(group, Symbol.getSymbol(l, "*") + group.substring(l));
        }
        return target;
    }
}

