/*
 * Decompiled with CFR 0.152.
 */
package com.github.desensitization;

import com.github.Symbol;
import com.github.desensitization.StringDesensitization;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IDCardDesensitization
implements StringDesensitization {
    private static final Pattern PATTERN15 = Pattern.compile("^([1-9][0-9]{5}[0-9]{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)[0-9]{3})$");
    private static final Pattern PATTERN18 = Pattern.compile("^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$");

    @Override
    public String desensitize(String target) {
        target = this.desensitize(PATTERN18, target);
        return this.desensitize(PATTERN15, target);
    }

    private String desensitize(Pattern pattern, String target) {
        if (target != null) {
            Matcher matcher = pattern.matcher(target);
            while (matcher.find()) {
                String group = matcher.group();
                int start = 4;
                int last = group.length() - 4;
                target = target.replace(target, group.substring(0, start) + Symbol.getSymbol(last, "*") + group.substring(last));
            }
        }
        return target;
    }
}

