/*
 * Decompiled with CFR 0.152.
 */
package com.github.eduramiba.webcamcapture;

import com.github.eduramiba.webcamcapture.drivers.NativeDriver;
import com.github.eduramiba.webcamcapture.drivers.WebcamDeviceWithBufferOperations;
import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDriver
extends Application {
    private static final Logger LOG = LoggerFactory.getLogger(TestDriver.class);
    public static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(4);

    public static void main(String[] args) {
        Webcam.setDriver((WebcamDriver)new NativeDriver());
        TestDriver.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        ImageView imageView = new ImageView();
        HBox root = new HBox();
        root.getChildren().add((Object)imageView);
        Webcam.getWebcams().stream().findFirst().ifPresent(camera -> {
            WebcamDevice device = camera.getDevice();
            LOG.info("Found camera: {}, device = {}", camera, (Object)device);
            int width = device.getResolution().width;
            int height = device.getResolution().height;
            final WritableImage fxImage = new WritableImage(width, height);
            Platform.runLater(() -> {
                imageView.setImage((Image)fxImage);
                stage.setWidth((double)width);
                stage.setHeight((double)height);
                stage.centerOnScreen();
            });
            camera.getLock().disable();
            camera.open();
            if (device instanceof WebcamDeviceWithBufferOperations) {
                final WebcamDeviceWithBufferOperations dev = (WebcamDeviceWithBufferOperations)device;
                EXECUTOR.scheduleAtFixedRate(new Runnable(){
                    private long lastFrameTimestamp = -1L;
                    final /* synthetic */ TestDriver this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        if (dev.updateFXIMage(fxImage, this.lastFrameTimestamp)) {
                            this.lastFrameTimestamp = dev.getLastFrameTimestamp();
                        }
                    }
                }, 0L, 16L, TimeUnit.MILLISECONDS);
            }
        });
        stage.setOnCloseRequest(t -> {
            Platform.exit();
            System.exit(0);
        });
        Scene scene = new Scene((Parent)root);
        stage.setScene(scene);
        stage.setTitle("Webcam example");
        stage.show();
    }
}

