/*
 * Decompiled with CFR 0.152.
 */
package com.github.eduramiba.webcamcapture.drivers.avfoundation.driver;

import com.github.eduramiba.webcamcapture.drivers.avfoundation.driver.AVFVideoDevice;
import com.github.eduramiba.webcamcapture.drivers.avfoundation.driver.LibVideoCapture;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.Dimension;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;

public class AVFDriver
implements WebcamDriver {
    private static final ByteBuffer buffer = ByteBuffer.allocateDirect(255);
    public static final Pattern RESOLUTION_PATTERN = Pattern.compile("[0-9]+x[0-9]+", 2);

    public synchronized List<WebcamDevice> getDevices() {
        LibVideoCapture lib = LibVideoCapture.INSTANCE;
        ArrayList<WebcamDevice> list = new ArrayList<WebcamDevice>();
        lib.vcavf_initialize();
        int count = lib.vcavf_devices_count();
        if (count < 1) {
            return list;
        }
        for (int devIndex = 0; devIndex < count; ++devIndex) {
            String uniqueId = AVFDriver.deviceUniqueId(devIndex);
            String name = AVFDriver.deviceName(devIndex);
            int formatCount = lib.vcavf_get_device_formats_count(devIndex);
            LinkedHashSet<Dimension> resolutions = new LinkedHashSet<Dimension>();
            for (int formatIndex = 0; formatIndex < formatCount; ++formatIndex) {
                String format = AVFDriver.deviceFormat(devIndex, formatIndex);
                Dimension resolution = AVFDriver.formatToDimension(format);
                if (resolution == null) continue;
                resolutions.add(resolution);
            }
            AVFVideoDevice device = new AVFVideoDevice(devIndex, uniqueId, name, resolutions);
            if (!device.isValid()) continue;
            list.add(device);
        }
        return list;
    }

    public boolean isThreadSafe() {
        return true;
    }

    private static String deviceUniqueId(int deviceIndex) {
        Pointer bufferP = Native.getDirectBufferPointer((Buffer)buffer);
        LibVideoCapture.INSTANCE.vcavf_get_device_unique_id(deviceIndex, bufferP, buffer.capacity());
        return bufferP.getString(0L, StandardCharsets.UTF_8.name());
    }

    private static String deviceModelId(int deviceIndex) {
        Pointer bufferP = Native.getDirectBufferPointer((Buffer)buffer);
        LibVideoCapture.INSTANCE.vcavf_get_device_model_id(deviceIndex, bufferP, buffer.capacity());
        return bufferP.getString(0L, StandardCharsets.UTF_8.name());
    }

    private static String deviceName(int deviceIndex) {
        Pointer bufferP = Native.getDirectBufferPointer((Buffer)buffer);
        LibVideoCapture.INSTANCE.vcavf_get_device_name(deviceIndex, bufferP, buffer.capacity());
        return bufferP.getString(0L, StandardCharsets.UTF_8.name());
    }

    private static String deviceFormat(int deviceIndex, int formatIndex) {
        Pointer bufferP = Native.getDirectBufferPointer((Buffer)buffer);
        LibVideoCapture.INSTANCE.vcavf_get_device_format(deviceIndex, formatIndex, bufferP, buffer.capacity());
        return bufferP.getString(0L, StandardCharsets.UTF_8.name());
    }

    private static Dimension formatToDimension(String format) {
        String resolution;
        String[] parts = format.split(";");
        if (parts.length > 0 && RESOLUTION_PATTERN.matcher(resolution = parts[0].trim()).matches()) {
            String[] widthAndHeight = resolution.split("[Xx]");
            return new Dimension(Integer.parseInt(widthAndHeight[0]), Integer.parseInt(widthAndHeight[1]));
        }
        return null;
    }
}

