/*
 * Decompiled with CFR 0.152.
 */
package com.github.eduramiba.webcamcapture.drivers.avfoundation.driver;

import com.github.eduramiba.webcamcapture.drivers.WebcamDeviceExtended;
import com.github.eduramiba.webcamcapture.drivers.WebcamDeviceWithCustomEvents;
import com.github.eduramiba.webcamcapture.drivers.avfoundation.driver.LibVideoCapture;
import com.sun.jna.Native;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AVFVideoDevice
implements WebcamDeviceExtended {
    private static final Logger LOG = LoggerFactory.getLogger(AVFVideoDevice.class);
    private final int deviceIndex;
    private final String id;
    private final String name;
    private final Dimension[] resolutions;
    private Dimension resolution;
    private boolean open = false;
    private int bytesPerRow = -1;
    private ByteBuffer imgBuffer = null;
    private byte[] arrayByteBuffer = null;
    private BufferedImage bufferedImage = null;
    private long lastFrameTimestamp = -1L;
    public static final int MAX_FPS = 30;

    public AVFVideoDevice(int deviceIndex, String id, String name, Collection<Dimension> resolutions) {
        this.deviceIndex = deviceIndex;
        this.id = id;
        this.name = name;
        this.resolutions = resolutions != null ? resolutions.toArray(new Dimension[0]) : new Dimension[]{};
        this.resolution = this.bestResolution(this.resolutions);
    }

    public boolean isValid() {
        return this.resolution != null && this.resolution.width > 0 && this.resolution.height > 0;
    }

    private Dimension bestResolution(Dimension[] resolutions) {
        Dimension best = null;
        int bestPixels = 0;
        for (Dimension dim : resolutions) {
            int px = dim.width * dim.height;
            if (px <= bestPixels) continue;
            best = dim;
            bestPixels = px;
        }
        return best;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Dimension[] getResolutions() {
        return this.resolutions;
    }

    public Dimension getResolution() {
        return this.resolution;
    }

    public void setResolution(Dimension resolution) {
        if (this.isOpen()) {
            return;
        }
        this.resolution = resolution;
    }

    public BufferedImage getImage() {
        return this.getImage(this.imgBuffer);
    }

    public synchronized void open() {
        int height;
        int width;
        int startResult;
        if (this.isOpen()) {
            return;
        }
        LibVideoCapture lib = LibVideoCapture.INSTANCE;
        int authStatus = lib.vcavf_has_videocapture_auth();
        if (authStatus != 0) {
            LOG.warn("Capture auth status = {}", (Object)authStatus);
        }
        if (authStatus != 0) {
            lib.vcavf_ask_videocapture_auth();
        }
        if ((startResult = lib.vcavf_start_capture(this.deviceIndex, width = this.resolution.width, height = this.resolution.height)) < 0) {
            LOG.warn("Capture start result for device {} = {}", (Object)this.id, (Object)startResult);
            return;
        }
        this.open = true;
        this.bufferedImage = new BufferedImage(width, height, 4);
        LOG.info("Device {} opened successfully", (Object)this.id);
    }

    public synchronized void close() {
        if (this.isOpen()) {
            LibVideoCapture.INSTANCE.vcavf_stop_capture(this.deviceIndex);
            this.open = false;
            this.bytesPerRow = -1;
            this.imgBuffer = null;
            this.arrayByteBuffer = null;
            this.bufferedImage = null;
        }
    }

    public void dispose() {
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public long getLastFrameTimestamp() {
        return this.lastFrameTimestamp;
    }

    public double getFPS() {
        return 30.0;
    }

    public synchronized ByteBuffer getImageBytes() {
        if (!this.isOpen()) {
            return null;
        }
        this.updateBuffer();
        return this.imgBuffer;
    }

    public synchronized void getImageBytes(ByteBuffer target) {
        if (!this.isOpen()) {
            return;
        }
        if (target.remaining() < this.imgBuffer.capacity()) {
            LOG.error("At least {} bytes needed but passed buffer has only {} remaining size", (Object)this.imgBuffer.capacity(), (Object)target.capacity());
            return;
        }
        this.updateBuffer();
        this.imgBuffer.rewind();
        target.put(this.imgBuffer);
    }

    public String toString() {
        return "AVFVideoDevice{deviceIndex=" + this.deviceIndex + ", id='" + this.id + "', name='" + this.name + "', resolutions=" + Arrays.toString(this.resolutions) + "}";
    }

    @Override
    public synchronized BufferedImage getImage(ByteBuffer byteBuffer) {
        if (!this.isOpen()) {
            return null;
        }
        this.updateBuffer();
        this.updateBufferedImage();
        return this.bufferedImage;
    }

    @Override
    public boolean updateFXIMage(WritableImage writableImage) {
        return this.updateFXIMage(writableImage, -1L);
    }

    @Override
    public synchronized boolean updateFXIMage(WritableImage writableImage, long lastFrameTimestamp) {
        if (!this.isOpen()) {
            return false;
        }
        this.updateBuffer();
        if (this.imgBuffer == null) {
            return false;
        }
        if (this.lastFrameTimestamp <= lastFrameTimestamp) {
            return false;
        }
        int videoWidth = this.resolution.width;
        int videoHeight = this.resolution.height;
        PixelWriter pw = writableImage.getPixelWriter();
        this.imgBuffer.mark();
        this.imgBuffer.position(0);
        pw.setPixels(0, 0, videoWidth, videoHeight, PixelFormat.getByteRgbInstance(), (Buffer)this.imgBuffer, this.bytesPerRow);
        return true;
    }

    private void updateBuffer() {
        if (LibVideoCapture.INSTANCE.vcavf_has_new_frame(this.deviceIndex)) {
            if (this.imgBuffer == null) {
                this.bytesPerRow = LibVideoCapture.INSTANCE.vcavf_frame_bytes_per_row(this.deviceIndex);
                int bufferSizeBytes = this.bytesPerRow * this.resolution.height;
                this.imgBuffer = ByteBuffer.allocateDirect(bufferSizeBytes);
                this.arrayByteBuffer = new byte[this.imgBuffer.capacity()];
            }
            if (LibVideoCapture.INSTANCE.vcavf_grab_frame(this.deviceIndex, Native.getDirectBufferPointer((Buffer)this.imgBuffer), this.imgBuffer.capacity())) {
                this.lastFrameTimestamp = System.currentTimeMillis();
            }
        }
    }

    private void updateBufferedImage() {
        if (!this.isOpen() || this.imgBuffer == null) {
            return;
        }
        int videoWidth = this.resolution.width;
        int videoHeight = this.resolution.height;
        ComponentSampleModel sampleModel = new ComponentSampleModel(0, videoWidth, videoHeight, 3, this.bytesPerRow, new int[]{0, 1, 2});
        this.imgBuffer.mark();
        this.imgBuffer.position(0);
        this.imgBuffer.get(this.arrayByteBuffer, 0, this.imgBuffer.capacity());
        this.imgBuffer.reset();
        DataBufferByte dataBuffer = new DataBufferByte(this.arrayByteBuffer, this.arrayByteBuffer.length);
        Raster raster = Raster.createRaster(sampleModel, dataBuffer, null);
        this.bufferedImage.setData(raster);
    }

    @Override
    public void addCustomEventsListener(WebcamDeviceWithCustomEvents.Listener listener) {
    }

    @Override
    public boolean removeCustomEventsListener(WebcamDeviceWithCustomEvents.Listener listener) {
        return true;
    }
}

