/*
 * Decompiled with CFR 0.152.
 */
package com.github.eduramiba.webcamcapture.drivers.nokhwa;

import com.github.eduramiba.webcamcapture.drivers.nokhwa.LibNokhwa;
import com.github.eduramiba.webcamcapture.drivers.nokhwa.NokhwaVideoDevice;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.Dimension;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NokhwaDriver
implements WebcamDriver {
    private static final Logger LOG = LoggerFactory.getLogger(NokhwaDriver.class);
    private static final ByteBuffer buffer = ByteBuffer.allocateDirect(255);

    public synchronized List<WebcamDevice> getDevices() {
        LibNokhwa lib = LibNokhwa.INSTANCE;
        ArrayList<WebcamDevice> list = new ArrayList<WebcamDevice>();
        if (lib.cnokhwa_initialize() != 0) {
            LOG.error("Error initializing native library");
            return list;
        }
        int devicesCount = lib.cnokhwa_devices_count();
        LOG.info("Available devices: {}", (Object)devicesCount);
        if (devicesCount < 1) {
            return list;
        }
        LinkedHashSet<String> availableFormats = new LinkedHashSet<String>();
        for (int devIndex = 0; devIndex < devicesCount; ++devIndex) {
            String uniqueId = NokhwaDriver.deviceUniqueId(devIndex);
            String name = NokhwaDriver.deviceName(devIndex);
            int formatCount = lib.cnokhwa_device_formats_count(devIndex);
            LinkedHashSet<Dimension> resolutions = new LinkedHashSet<Dimension>();
            int maxFps = 0;
            for (int formatIndex = 0; formatIndex < formatCount; ++formatIndex) {
                String formatType = NokhwaDriver.deviceFormatType(devIndex, formatIndex);
                int formatWidth = lib.cnokhwa_device_format_width(devIndex, formatIndex);
                int formatHeight = lib.cnokhwa_device_format_height(devIndex, formatIndex);
                int formatFps = lib.cnokhwa_device_format_frame_rate(devIndex, formatIndex);
                availableFormats.add(String.format("%dx%d %s (%d fps)", formatWidth, formatHeight, formatType, formatFps));
                Dimension resolution = new Dimension(formatWidth, formatHeight);
                resolutions.add(resolution);
                if (formatFps <= maxFps) continue;
                maxFps = formatFps;
            }
            LOG.info("Found camera {} (id {}) with available formats: {}", new Object[]{name, uniqueId, availableFormats});
            NokhwaVideoDevice device = new NokhwaVideoDevice(devIndex, uniqueId, name, resolutions, maxFps);
            if (!device.isValid()) continue;
            list.add(device);
        }
        return list;
    }

    public boolean isThreadSafe() {
        return true;
    }

    private static String deviceUniqueId(int deviceIndex) {
        Pointer bufferP = Native.getDirectBufferPointer((Buffer)buffer);
        LibNokhwa.INSTANCE.cnokhwa_device_unique_id(deviceIndex, bufferP, buffer.capacity());
        return bufferP.getString(0L, StandardCharsets.UTF_8.name());
    }

    private static String deviceName(int deviceIndex) {
        Pointer bufferP = Native.getDirectBufferPointer((Buffer)buffer);
        LibNokhwa.INSTANCE.cnokhwa_device_name(deviceIndex, bufferP, buffer.capacity());
        return bufferP.getString(0L, StandardCharsets.UTF_8.name());
    }

    private static String deviceFormatType(int deviceIndex, int formatIndex) {
        Pointer bufferP = Native.getDirectBufferPointer((Buffer)buffer);
        LibNokhwa.INSTANCE.cnokhwa_device_format_type(deviceIndex, formatIndex, bufferP, buffer.capacity());
        return bufferP.getString(0L, StandardCharsets.UTF_8.name());
    }
}

