/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner;

import io.github.eealba.jasoner.ModifierStrategy;
import io.github.eealba.jasoner.NamingStrategy;
import io.github.eealba.jasoner.SerializationStrategy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class JasonerConfig {
    public static final JasonerConfig DEFAULT = new Builder().build();
    private final NamingStrategy namingStrategy;
    private final ModifierStrategy modifierStrategy;
    private final boolean removePrefixAccessors;
    private final Charset charset;
    private final SerializationStrategy serializationStrategy;
    private final boolean pretty;

    private JasonerConfig(Builder builder) {
        this.namingStrategy = builder.namingStrategy;
        this.modifierStrategy = builder.modifierStrategy;
        this.removePrefixAccessors = builder.removePrefixAccessors;
        this.charset = builder.charset;
        this.serializationStrategy = builder.serializationStrategy;
        this.pretty = builder.pretty;
    }

    public NamingStrategy namingStrategy() {
        return this.namingStrategy;
    }

    public ModifierStrategy modifierStrategy() {
        return this.modifierStrategy;
    }

    public boolean removePrefixAccessors() {
        return this.removePrefixAccessors;
    }

    public Charset charset() {
        return this.charset;
    }

    public SerializationStrategy serializationStrategy() {
        return this.serializationStrategy;
    }

    public boolean pretty() {
        return this.pretty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean pretty;
        private NamingStrategy namingStrategy = NamingStrategy.CAMEL_CASE;
        private ModifierStrategy modifierStrategy = ModifierStrategy.PUBLIC;
        private boolean removePrefixAccessors = true;
        private Charset charset = StandardCharsets.UTF_8;
        private SerializationStrategy serializationStrategy = SerializationStrategy.BOTH;

        public Builder namingStrategy(NamingStrategy namingStrategy) {
            this.namingStrategy = namingStrategy;
            return this;
        }

        public Builder modifierStrategy(ModifierStrategy modifierStrategy) {
            this.modifierStrategy = modifierStrategy;
            return this;
        }

        public Builder removePrefixAccessors(boolean removePrefixAccessors) {
            this.removePrefixAccessors = removePrefixAccessors;
            return this;
        }

        public Builder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder serializationStrategy(SerializationStrategy serializationStrategy) {
            this.serializationStrategy = serializationStrategy;
            return this;
        }

        public Builder pretty(boolean pretty) {
            this.pretty = pretty;
            return this;
        }

        public JasonerConfig build() {
            return new JasonerConfig(this);
        }
    }
}

