/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.internal.Convert;
import io.github.eealba.jasoner.internal.ConvertInstant;
import io.github.eealba.jasoner.internal.ConvertSimpleRecord;
import java.math.BigDecimal;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;

class ConvertFactory {
    ConvertFactory() {
    }

    public static Convert<Object, ?> getConverter(Class<?> type) {
        Convert<Object, Object> convert;
        String name;
        switch (name = type.getSimpleName()) {
            case "byte": 
            case "Byte": {
                Convert<Object, Object> convert2 = data -> Byte.parseByte(data.toString());
                break;
            }
            case "short": 
            case "Short": {
                Convert<Object, Object> convert2 = data -> Short.parseShort(data.toString());
                break;
            }
            case "char": 
            case "Character": {
                Convert<Object, Object> convert2 = data -> Character.valueOf(data.toString().charAt(0));
                break;
            }
            case "int": 
            case "Integer": {
                Convert<Object, Object> convert2 = data -> Integer.parseInt(data.toString());
                break;
            }
            case "long": 
            case "Long": {
                Convert<Object, Object> convert2 = data -> Long.parseLong(data.toString());
                break;
            }
            case "float": 
            case "Float": {
                Convert<Object, Object> convert2 = data -> Float.valueOf(Float.parseFloat(data.toString()));
                break;
            }
            case "double": 
            case "Double": {
                Convert<Object, Object> convert2 = data -> Double.parseDouble(data.toString());
                break;
            }
            case "BigDecimal": {
                Convert<Object, Object> convert2 = data -> ConvertFactory.numericValue(data.toString());
                break;
            }
            case "boolean": 
            case "Boolean": {
                Convert<Object, Object> convert2 = data -> Boolean.parseBoolean(data.toString());
                break;
            }
            case "LocalDate": {
                Convert<Object, Object> convert2 = data -> LocalDate.parse(data.toString());
                break;
            }
            case "LocalDateTime": {
                Convert<Object, Object> convert2 = data -> LocalDateTime.parse(data.toString());
                break;
            }
            case "LocalTime": {
                Convert<Object, Object> convert2 = data -> LocalTime.parse(data.toString());
                break;
            }
            case "Date": {
                Convert<Object, Object> convert2 = data -> Date.from(Instant.parse(data.toString()));
                break;
            }
            case "OffsetDateTime": {
                Convert<Object, Object> convert2 = data -> OffsetDateTime.parse(data.toString());
                break;
            }
            case "UUID": {
                Convert<Object, Object> convert2 = data -> UUID.fromString(data.toString());
                break;
            }
            case "ZoneOffset": {
                Convert<Object, Object> convert2 = data -> ZoneOffset.of(data.toString());
                break;
            }
            case "URI": {
                Convert<Object, Object> convert2 = data -> URI.create(data.toString());
                break;
            }
            default: {
                Convert<Object, Object> convert2 = convert = null;
            }
        }
        if (convert != null) {
            return convert;
        }
        if (type == Instant.class) {
            return new ConvertInstant();
        }
        if (type.isRecord() && type.getDeclaredConstructors()[0].getParameters().length == 1) {
            return new ConvertSimpleRecord(type);
        }
        return obj -> obj;
    }

    private static BigDecimal numericValue(String data) {
        return ConvertFactory.getPowerDelimiter(data).map(pos -> new BigDecimal(data.substring(0, (int)pos)).pow(Integer.parseInt(data.substring(pos + 1)))).orElseGet(() -> new BigDecimal(data));
    }

    private static Optional<Integer> getPowerDelimiter(String data) {
        int pos = data.toLowerCase().indexOf("e");
        if (pos == -1) {
            return Optional.empty();
        }
        return Optional.of(pos);
    }
}

