/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.Jasoner;
import io.github.eealba.jasoner.JasonerConfig;
import io.github.eealba.jasoner.JasonerException;
import io.github.eealba.jasoner.internal.JsonDeserializer;
import io.github.eealba.jasoner.internal.JsonDeserializerImpl;
import io.github.eealba.jasoner.internal.JsonSerializer;
import io.github.eealba.jasoner.internal.JsonSerializerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;

class JasonerImpl
implements Jasoner {
    private final JasonerConfig config;
    private final JsonSerializer serializer;
    private final JsonDeserializer deserializer;

    JasonerImpl(JasonerConfig config) {
        this.config = config;
        this.serializer = new JsonSerializerImpl(config);
        this.deserializer = new JsonDeserializerImpl();
    }

    @Override
    public String toJson(Object object) {
        StringWriter writer = new StringWriter();
        this.toJson(object, writer);
        return ((Object)writer).toString();
    }

    @Override
    public void toJson(Object object, OutputStream stream) {
        OutputStreamWriter writer = new OutputStreamWriter(stream, this.config.charset());
        this.toJson(object, writer);
    }

    @Override
    public void toJson(Object object, Writer writer) {
        try {
            this.serializer.serialize(writer, object);
        }
        catch (IOException e) {
            throw new JasonerException(e);
        }
    }

    @Override
    public <T> T fromJson(InputStream stream, Class<T> type) {
        InputStreamReader reader = new InputStreamReader(stream, this.config.charset());
        return this.fromJson(reader, type);
    }

    @Override
    public <T> T fromJson(String json, Class<T> type) {
        StringReader reader = new StringReader(json);
        return this.fromJson(reader, type);
    }

    @Override
    public <T> T fromJson(String result, Type genericSuperclass) {
        StringReader reader = new StringReader(result);
        return this.deserializer.deserialize((Reader)reader, genericSuperclass);
    }

    @Override
    public <T> T fromJson(Reader reader, Class<T> type) {
        return this.deserializer.deserialize(reader, type);
    }
}

