/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.JasonerException;
import io.github.eealba.jasoner.internal.JsonDeserializer;
import io.github.eealba.jasoner.internal.JsonTokenizer;
import io.github.eealba.jasoner.internal.JsonTokenizerImpl;
import io.github.eealba.jasoner.internal.ObjectCreator;
import io.github.eealba.jasoner.internal.Reflects;
import io.github.eealba.jasoner.internal.Token;
import io.github.eealba.jasoner.internal.TokenType;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

class JsonDeserializerImpl
implements JsonDeserializer {
    private static final String ERROR_UNEXPECTED_TOKEN = "Unexpected token '%s'";

    JsonDeserializerImpl() {
    }

    @Override
    public <T> T deserialize(Reader data, Class<T> clazz) {
        JsonTokenizerImpl tokenizer = new JsonTokenizerImpl(this.readAll(data));
        Token token = tokenizer.next();
        if (token.type() == TokenType.OBJECT_START) {
            return this.deserializeObject(tokenizer, clazz);
        }
        if (token.type() == TokenType.ARRAY_START) {
            Class<?> arrayElementClass = this.getArrayElementClass(clazz);
            if (clazz.isRecord()) {
                ArrayList values = this.deserializeArray(tokenizer, ArrayList.class, arrayElementClass);
                return clazz.cast(Reflects.createSingleRecord(clazz, values).orElseThrow());
            }
            return this.deserializeArray(tokenizer, clazz, arrayElementClass);
        }
        throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
    }

    private Class<?> getArrayElementClass(Class<?> clazz) {
        if (clazz.isRecord() && Reflects.getSingleRecordParameterClass(clazz).isPresent()) {
            return Reflects.getSingleRecordParameterClass(clazz).get();
        }
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        return HashMap.class;
    }

    @Override
    public <T> T deserialize(Reader data, Type genericSuperclass) {
        JsonTokenizerImpl tokenizer = new JsonTokenizerImpl(this.readAll(data));
        Token token = tokenizer.next();
        JsonDeserializerImpl.expectedToken(tokenizer.current(), TokenType.ARRAY_START);
        if (token.type() == TokenType.ARRAY_START) {
            Class<?> classType = Reflects.getClass(genericSuperclass.getTypeName());
            return (T)this.deserializeArray(tokenizer, ArrayList.class, classType);
        }
        return null;
    }

    private <T> T deserializeObject(JsonTokenizer tokenizer, Class<T> clazz) {
        JsonDeserializerImpl.expectedToken(tokenizer.current(), TokenType.OBJECT_START);
        return this.createObject(clazz, tokenizer);
    }

    private <T> T deserializeArray(JsonTokenizer tokenizer, Class<T> clazz, Class<?> clazz2) {
        JsonDeserializerImpl.expectedToken(tokenizer.current(), TokenType.ARRAY_START);
        ArrayList<Object> list = new ArrayList<Object>();
        this.moveArrayValues(list, tokenizer, clazz2);
        if (clazz.isArray()) {
            return clazz.cast(Reflects.createArray(clazz, list));
        }
        return clazz.cast(list);
    }

    private String readAll(Reader data) {
        StringBuilder sb = new StringBuilder();
        try {
            int c;
            while ((c = data.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (Exception e) {
            throw new JasonerException(e);
        }
        return sb.toString();
    }

    private <T> T createObject(Class<T> clazz, JsonTokenizer tokenizer) {
        ObjectCreator<T> creator = new ObjectCreator<T>(clazz);
        JsonDeserializerImpl.expectedToken(tokenizer.current(), TokenType.OBJECT_START);
        this.moveProperties(creator, tokenizer);
        return creator.create();
    }

    private void moveProperties(ObjectCreator<?> obj, JsonTokenizer tokenizer) {
        Token token;
        while (tokenizer.hasNext() && (token = tokenizer.next()).type() != TokenType.OBJECT_END) {
            String name = JsonDeserializerImpl.expectedToken(token, TokenType.TEXT).stringValue();
            JsonDeserializerImpl.expectedToken(tokenizer.next(), TokenType.COLON);
            JsonDeserializerImpl.expectedTokenValue(tokenizer.next());
            this.moveProperty(obj, name, tokenizer);
            token = tokenizer.next();
            JsonDeserializerImpl.expectedTokens(token, TokenType.COMMA, TokenType.OBJECT_END);
            if (token.type() != TokenType.OBJECT_END) continue;
            break;
        }
    }

    private void moveProperty(ObjectCreator<?> obj, String name, JsonTokenizer tokenizer) {
        Optional<Class<?>> parameterClass = obj.getParameterClass(name);
        if (parameterClass.isPresent()) {
            Class<?> ctype = parameterClass.get();
            T[] value = this.getValue(tokenizer, ctype);
            if (ctype.isArray() && value instanceof List) {
                List list = (List)value;
                value = Reflects.createArray(ctype, list);
            }
            obj.setValue(name, value);
        } else {
            Object value = this.getValue(tokenizer, HashMap.class);
            if (obj.isMap()) {
                obj.setValue(name, value);
            }
        }
    }

    private Object getValue(JsonTokenizer tokenizer, Class<?> ctype) {
        Object value;
        Token token = tokenizer.current();
        if (token.type() == TokenType.OBJECT_START) {
            value = this.createObject(ctype, tokenizer);
        } else if (token.type() == TokenType.ARRAY_START) {
            ArrayList<Object> list = new ArrayList<Object>();
            this.moveArrayValues(list, tokenizer, ctype);
            value = list;
        } else {
            value = token.typeValue(ctype);
        }
        return value;
    }

    private void moveArrayValues(List<Object> list, JsonTokenizer tokenizer, Class<?> ctype) {
        Token token;
        while (tokenizer.hasNext() && (token = tokenizer.next()).type() != TokenType.ARRAY_END) {
            JsonDeserializerImpl.expectedTokenValue(token);
            if (token.type() == TokenType.OBJECT_START) {
                list.add(this.createObject(ctype, tokenizer));
            } else {
                list.add(token.value());
            }
            token = tokenizer.next();
            JsonDeserializerImpl.expectedTokens(token, TokenType.COMMA, TokenType.ARRAY_END);
            if (token.type() != TokenType.ARRAY_END) continue;
            break;
        }
    }

    private static Token expectedToken(Token token, TokenType expected) {
        if (token == null) {
            throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, "null"));
        }
        if (token.type() != expected) {
            throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
        }
        return token;
    }

    private static Token expectedTokens(Token token, TokenType ... expected) {
        if (token == null) {
            throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, "null"));
        }
        for (TokenType t : expected) {
            if (token.type() != t) continue;
            return token;
        }
        throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
    }

    private static void expectedTokenValue(Token token) {
        if (token == null) {
            throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, "null"));
        }
        if (token.type() != TokenType.TEXT && token.type() != TokenType.NUMBER && token.type() != TokenType.TRUE && token.type() != TokenType.FALSE && token.type() != TokenType.NULL && token.type() != TokenType.ARRAY_START && token.type() != TokenType.OBJECT_START) {
            throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
        }
    }
}

