/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.JsonObject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JsonObjectImpl
implements JsonObject {
    private final Map<String, Object> map;

    JsonObjectImpl(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public Set<String> keys() {
        return this.map.keySet();
    }

    @Override
    public String getString(String key) {
        return (String)this.get(key);
    }

    @Override
    public Integer getInteger(String key) {
        return (Integer)this.get(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    @Override
    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    @Override
    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    @Override
    public Float getFloat(String key) {
        return (Float)this.get(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return (BigDecimal)this.get(key);
    }

    @Override
    public JsonObject getJsonObject(String key) {
        return (JsonObject)this.get(key);
    }

    @Override
    public List<?> getJsonArray(String key) {
        return (List)this.get(key);
    }

    @Override
    public Object get(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        Object value = this.map.get(key);
        if (value != null) {
            return value;
        }
        String[] keys = key.split("\\.");
        Object current = this.map;
        for (String k : keys) {
            if (current instanceof Map) {
                Map<String, Object> map2 = current;
                current = map2.get(k);
                continue;
            }
            if (current instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)current;
                current = jsonObject.get(k);
                continue;
            }
            if (!(current instanceof List)) continue;
            try {
                int index = Integer.parseInt(k);
                current = ((List)current).get(index);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid index: " + k, e);
            }
        }
        if (current == this.map) {
            throw new IllegalArgumentException("Key not found: " + key);
        }
        return current;
    }
}

