/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.JasonerConfig;
import io.github.eealba.jasoner.JasonerProperty;
import io.github.eealba.jasoner.JasonerSingleVO;
import io.github.eealba.jasoner.JsonObject;
import io.github.eealba.jasoner.SerializationStrategy;
import io.github.eealba.jasoner.internal.JsonSerializer;
import io.github.eealba.jasoner.internal.JsonWriter;
import io.github.eealba.jasoner.internal.NamingFactory;
import io.github.eealba.jasoner.internal.Reflects;
import io.github.eealba.jasoner.internal.Token;
import io.github.eealba.jasoner.internal.TokenImpl;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

class JsonSerializerImpl
implements JsonSerializer {
    private final JasonerConfig config;

    JsonSerializerImpl(JasonerConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public void serialize(Writer writer, Object obj) throws IOException {
        ValueData valueData;
        Objects.requireNonNull(obj);
        JsonWriter jsonWriter = new JsonWriter(Objects.requireNonNull(writer), this.config.pretty());
        if (obj.getClass().isRecord() && Reflects.getSingleRecordParameterClass(obj.getClass()).isPresent() && (valueData = this.valueDataList(obj).get(0)).getName(s -> s).equals("value") && valueData.getValue() instanceof List) {
            obj = valueData.getValue();
        }
        if (obj.getClass().isArray()) {
            obj = List.of((Object[])obj);
        }
        if (obj instanceof List) {
            List<Object> list = obj;
            this.jsonArray(list, jsonWriter);
        } else {
            this.json(obj, jsonWriter);
        }
    }

    private void jsonArray(List<?> list, JsonWriter writer) throws IOException {
        writer.append(TokenImpl.ARRAY_START);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object value = list.get(i);
            if (this.isSingleVO(value.getClass())) {
                value = this.valueDataList(value).get(0).getValue();
            }
            if (value instanceof String) {
                String str = (String)value;
                writer.append(TokenImpl.createTextToken(str));
            } else if (value instanceof Number) {
                Number number = (Number)value;
                writer.append(TokenImpl.createNumberToken(number.toString()));
            } else if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                writer.append(TokenImpl.createBooleanToken(bool.toString()));
            } else if (value instanceof Map) {
                Map map = (Map)value;
                this.jsonMap(map, writer);
            } else if (value instanceof List) {
                List list1 = (List)value;
                this.jsonArray(list1, writer);
            } else {
                this.json(value, writer);
            }
            if (i >= size - 1) continue;
            writer.append(TokenImpl.COMMA);
        }
        writer.append(TokenImpl.ARRAY_END);
    }

    private void json(Object entity, JsonWriter writer) throws IOException {
        writer.append(TokenImpl.OBJECT_START);
        ArrayList<ValueData> valueDataList = this.valueDataList(entity);
        this.serializeValueData(valueDataList, writer);
        writer.append(TokenImpl.OBJECT_END);
    }

    private ArrayList<ValueData> valueDataList(Object entity) {
        return JsonObject.class.isAssignableFrom(entity.getClass()) ? this.valueDataListFromJsonObject((JsonObject)entity) : this.valueDataListFromEntity(entity);
    }

    private ArrayList<ValueData> valueDataListFromEntity(Object entity) {
        ArrayList<ValueData> valueDataList = new ArrayList<ValueData>();
        if (this.config.serializationStrategy() == SerializationStrategy.BOTH || this.config.serializationStrategy() == SerializationStrategy.METHOD) {
            valueDataList.addAll(Reflects.getGetterMethods(entity, this.config.modifierStrategy()).stream().map(method -> new ValueData(entity, (Method)method, null)).toList());
        }
        if (this.config.serializationStrategy() == SerializationStrategy.BOTH || this.config.serializationStrategy() == SerializationStrategy.FIELD) {
            valueDataList.addAll(Reflects.getFields(entity, this.config.modifierStrategy()).stream().map(field -> new ValueData(entity, null, (Field)field)).toList());
        }
        return valueDataList;
    }

    private ArrayList<ValueData> valueDataListFromJsonObject(JsonObject entity) {
        List<1> res = entity.keys().stream().map(key -> {
            final Object value = entity.get((String)key);
            return new ValueData(entity, null, null, (String)key){
                final /* synthetic */ String val$key;
                {
                    this.val$key = string;
                    super(entity, method, field);
                }

                @Override
                Object getValue() {
                    return value;
                }

                @Override
                String getName(Function<String, String> namingFunction) {
                    return this.val$key;
                }
            };
        }).toList();
        return new ArrayList<ValueData>(res);
    }

    private void serializeValueData(List<ValueData> arrList, JsonWriter writer) throws IOException {
        List<ValueData> dataList = arrList.stream().filter(vd -> vd.getValue() != null).toList();
        for (int i = 0; i < dataList.size(); ++i) {
            ValueData valueData = dataList.get(i);
            Object value = valueData.getValue();
            String name = valueData.getName(this.getNamingFunction());
            writer.append(TokenImpl.createTextToken(name));
            writer.append(TokenImpl.COLON);
            this.propertyValue(writer, value);
            if (i >= dataList.size() - 1) continue;
            writer.append(TokenImpl.COMMA);
        }
    }

    private Function<String, String> getNamingFunction() {
        return source -> NamingFactory.get(this.config.namingStrategy()).apply(this.removePrefix((String)source));
    }

    public String removePrefix(String name) {
        Objects.requireNonNull(name);
        if (this.config.removePrefixAccessors()) {
            return name.replaceAll("^(is|has|get)(?=[A-Z])", "");
        }
        return name;
    }

    private void propertyValue(JsonWriter writer, Object value) throws IOException {
        if (value.getClass().isArray()) {
            value = List.of((Object[])value);
        }
        if (value instanceof Map) {
            Map map = (Map)((Object)value);
            this.jsonMap(map, writer);
            return;
        }
        if (value instanceof List) {
            List<Object> list = value;
            this.jsonArray(list, writer);
            return;
        }
        Optional<Token> tokenValue = this.getTokenValue(value);
        if (tokenValue.isPresent()) {
            writer.append(tokenValue.get());
            return;
        }
        this.json(value, writer);
    }

    private void jsonMap(Map<?, ?> map, JsonWriter writer) throws IOException {
        writer.append(TokenImpl.OBJECT_START);
        int size = map.size();
        int i = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof String) {
                String str = (String)key;
                writer.append(TokenImpl.createTextToken(str));
            } else {
                writer.append(TokenImpl.createTextToken(key.toString()));
            }
            writer.append(TokenImpl.COLON);
            Optional<Token> tokenValue = this.getTokenValue(value);
            if (tokenValue.isPresent()) {
                writer.append(tokenValue.get());
            } else if (value instanceof List) {
                List list = (List)value;
                this.jsonArray(list, writer);
            } else if (value instanceof Map) {
                Map map2 = (Map)value;
                this.jsonMap(map2, writer);
            } else if (value.getClass().isArray()) {
                this.jsonArray(List.of((Object[])value), writer);
            } else {
                this.json(value, writer);
            }
            if (i < size - 1) {
                writer.append(TokenImpl.COMMA);
            }
            ++i;
        }
        writer.append(TokenImpl.OBJECT_END);
    }

    private Optional<Token> getTokenValue(Object value) {
        Optional<Token> singleValue = JsonSerializerImpl.getSingleValue(value);
        if (singleValue.isPresent()) {
            return singleValue;
        }
        ArrayList<ValueData> valueDataList = this.valueDataList(value);
        if (valueDataList.size() == 1 && this.isSingleVO(value.getClass())) {
            Object newValue = valueDataList.get(0).getValue();
            return JsonSerializerImpl.getSingleValue(newValue);
        }
        return Optional.empty();
    }

    private boolean isSingleVO(Class<?> aClass) {
        return aClass.getAnnotation(JasonerSingleVO.class) != null;
    }

    private static Optional<Token> getSingleValue(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return Optional.of(TokenImpl.createTextToken(str));
        }
        if (value instanceof Enum) {
            Enum enu = (Enum)value;
            String tmp = enu.toString();
            if (tmp.equals("true") || tmp.equals("false")) {
                return Optional.of(TokenImpl.createBooleanToken(tmp));
            }
            Optional<JasonerProperty> jasonerProperty = Reflects.getJasonerProperty(value.getClass(), enu);
            return jasonerProperty.map(property -> TokenImpl.createTextToken(property.value())).or(() -> Optional.of(TokenImpl.createTextToken(tmp)));
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(TokenImpl.createNumberToken(number.toString()));
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return Optional.of(TokenImpl.createBooleanToken(bool.toString()));
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return Optional.of(TokenImpl.createTextToken(date.toInstant().toString()));
        }
        if (value instanceof Map) {
            return Optional.empty();
        }
        if (value instanceof List) {
            return Optional.empty();
        }
        if (!value.getClass().isArray() && JsonSerializerImpl.classIgnoredForSerialization(value.getClass())) {
            return Optional.of(TokenImpl.createTextToken(value.toString()));
        }
        return Optional.empty();
    }

    private static boolean classIgnoredForSerialization(Class<?> clazz) {
        return clazz.getName().startsWith("java");
    }

    static class ValueData {
        private final Method method;
        private final Field field;
        private final Object entity;

        private ValueData(Object entity, Method method, Field field) {
            this.method = method;
            this.field = field;
            this.entity = entity;
        }

        Object getValue() {
            if (this.method != null) {
                return Reflects.invokeMethod(this.method, this.entity);
            }
            if (this.field != null) {
                return Reflects.getFieldValue(this.field, this.entity);
            }
            return null;
        }

        String getName(Function<String, String> namingFunction) {
            if (this.method != null) {
                JasonerProperty jasonerProperty = this.method.getAnnotation(JasonerProperty.class);
                return jasonerProperty != null ? jasonerProperty.value() : namingFunction.apply(this.method.getName());
            }
            if (this.field != null) {
                JasonerProperty jasonerProperty = this.field.getAnnotation(JasonerProperty.class);
                return jasonerProperty != null ? jasonerProperty.value() : namingFunction.apply(this.field.getName());
            }
            return null;
        }
    }
}

