/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.internal.Token;
import io.github.eealba.jasoner.internal.TokenType;
import java.io.IOException;
import java.io.Writer;

class JsonWriter {
    private final Writer writer;
    private final boolean pretty;
    private int indent = 0;
    private static final String escape = String.valueOf(new char[]{'\\', '\\', '\"'});

    JsonWriter(Writer writer, boolean pretty) {
        this.writer = writer;
        this.pretty = pretty;
    }

    JsonWriter append(Token c) throws IOException {
        this.putLeading(c);
        this.write(c);
        this.putTrailing(c);
        return this;
    }

    private void putLeading(Token c) throws IOException {
        if (this.pretty && (c.type() == TokenType.OBJECT_END || c.type() == TokenType.ARRAY_END)) {
            --this.indent;
            this.appendNewLine();
            this.indent();
        }
    }

    private void write(Token c) throws IOException {
        if (c.type() == TokenType.TEXT) {
            this.writer.write(34);
        }
        this.writer.write(this.escapeQuotes(c.stringValue()));
        if (c.type() == TokenType.TEXT) {
            this.writer.write(34);
        }
    }

    private String escapeQuotes(String value) {
        return value.replaceAll("(?<!\\\\)\"", "\\\\\"");
    }

    private void putTrailing(Token c) throws IOException {
        if (this.pretty) {
            if (c.type() == TokenType.OBJECT_START || c.type() == TokenType.ARRAY_START) {
                ++this.indent;
                this.appendNewLine();
                this.indent();
            }
            if (c.type() == TokenType.COMMA) {
                this.appendNewLine();
                this.indent();
            }
            if (c.type() == TokenType.COLON) {
                this.writer.write(32);
            }
        }
    }

    private void appendNewLine() throws IOException {
        if (this.pretty) {
            this.writer.append('\n');
        }
    }

    private void indent() throws IOException {
        if (this.pretty) {
            for (int localIndent = this.indent; localIndent > 0; --localIndent) {
                this.writer.append("  ");
            }
        }
    }

    String writertoString() {
        return this.writer.toString();
    }
}

