/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.JasonerException;
import io.github.eealba.jasoner.JsonObject;
import io.github.eealba.jasoner.internal.ConvertFactory;
import io.github.eealba.jasoner.internal.Reflects;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ObjectCreator<T> {
    private final Class<T> clazz;
    private final Class<?> clazzComponentType;
    private final Object obj;

    ObjectCreator(Class<T> clazz) {
        this.clazz = clazz;
        Class<?> clazz2 = this.clazzComponentType = clazz.isArray() ? clazz.getComponentType() : null;
        this.obj = clazz.isRecord() || Map.class.isAssignableFrom(clazz) || JsonObject.class.isAssignableFrom(clazz) ? new HashMap() : (clazz.isArray() ? Reflects.createBuilder(this.clazzComponentType).orElseGet(() -> Reflects.createJsonObject(this.clazzComponentType).orElseThrow(() -> new JasonerException("Cannot create instance of " + clazz.getName()))) : Reflects.createBuilder(clazz).orElseGet(() -> Reflects.createJsonObject(clazz).orElseThrow(() -> new JasonerException("Cannot create instance of " + clazz.getName()))));
    }

    boolean isMap() {
        return this.obj instanceof Map;
    }

    private Optional<Map<String, Object>> getMap() {
        if (this.obj instanceof Map) {
            Map map = (Map)this.obj;
            return Optional.of(map);
        }
        return Optional.empty();
    }

    void setValue(String name, Object valueArg) {
        Optional<Class<?>> parameterClass = this.getParameterClass(name);
        Object value = JsonObject.class.isAssignableFrom(this.clazz) && valueArg instanceof Map ? Reflects.createJsonObject(this.clazz, valueArg).orElseThrow(() -> new JasonerException("Cannot create instance of " + this.clazz.getName())) : (parameterClass.isPresent() ? ObjectCreator.convertValue(parameterClass.get(), valueArg) : valueArg);
        if (this.isMap()) {
            this.getMap().orElseThrow().put(name, value);
        } else {
            Optional<Method> setter = Reflects.getSetterMethod(this.obj, name, value);
            if (setter.isPresent()) {
                Reflects.invokeMethod(setter.get(), this.obj, new Object[]{value});
            } else {
                Reflects.getField(this.obj, name).ifPresent(f -> Reflects.setFieldValue(f, this.obj, value));
            }
        }
    }

    static Object convertValue(Class<?> parameterClass, Object valueArg) {
        if (parameterClass.isInstance(valueArg)) {
            return valueArg;
        }
        if (valueArg instanceof List) {
            List list = (List)valueArg;
            return list.stream().map(o -> ObjectCreator.convertValue(parameterClass, o)).toList();
        }
        return ConvertFactory.getConverter(parameterClass).convert(valueArg);
    }

    Optional<Class<?>> getParameterClass(String name) {
        if (JsonObject.class.isAssignableFrom(this.clazz)) {
            return Optional.of(this.clazz);
        }
        if (this.clazz.isRecord()) {
            return Reflects.getRecordParameterClass(this.clazz, name);
        }
        return Reflects.getSetterMethodParameterClass(this.obj, name).or(() -> Reflects.getFieldParameterClass(this.obj, name));
    }

    T create() {
        if (this.clazz.isRecord()) {
            return this.createRecord();
        }
        return this.createInstance();
    }

    private T createRecord() {
        return Reflects.createRecord(this.clazz, this.getMap().orElseThrow()).orElseThrow();
    }

    private T createInstance() {
        if (JsonObject.class.isAssignableFrom(this.clazz)) {
            return (T)Reflects.createJsonObject(this.clazz, this.obj).orElseThrow(() -> new JasonerException("Cannot create instance of " + this.clazz.getName()));
        }
        if (this.clazz.isArray()) {
            return (T)Reflects.createObjectFromBuilderInstance(this.obj, this.clazzComponentType).orElseThrow(() -> new JasonerException("Cannot create instance of " + this.clazz.getName()));
        }
        if (this.obj.getClass().equals(this.clazz) || this.clazz.isInstance(this.obj)) {
            return this.clazz.cast(this.obj);
        }
        return Reflects.createObjectFromBuilderInstance(this.obj, this.clazz).orElseThrow(() -> new JasonerException("Cannot create instance of " + this.clazz.getName()));
    }
}

