/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.JasonerException;
import io.github.eealba.jasoner.JasonerProperty;
import io.github.eealba.jasoner.JasonerTransient;
import io.github.eealba.jasoner.JsonObject;
import io.github.eealba.jasoner.ModifierStrategy;
import io.github.eealba.jasoner.NamingStrategy;
import io.github.eealba.jasoner.internal.JsonObjectImpl;
import io.github.eealba.jasoner.internal.NamingFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;

class Reflects {
    private static final Predicate<Method> staticMethod = method -> Modifier.isStatic(method.getModifiers());
    private static final Predicate<Method> instanceMethod = method -> !Modifier.isStatic(method.getModifiers());
    private static final Predicate<Method> publicMethod = method -> Modifier.isPublic(method.getModifiers());
    private static final Predicate<Method> protectedMethod = method -> Modifier.isProtected(method.getModifiers());
    private static final Predicate<Method> privateMethod = method -> Modifier.isPrivate(method.getModifiers());
    private static final Predicate<Field> publicField = field -> Modifier.isPublic(field.getModifiers());
    private static final Predicate<Field> protectedField = field -> Modifier.isProtected(field.getModifiers());
    private static final Predicate<Field> privateField = field -> Modifier.isPrivate(field.getModifiers());
    private static final Predicate<Method> onceParameterMethod = method -> method.getParameterCount() == 1;
    private static final Predicate<Method> noParameterMethod = method -> method.getParameterCount() == 0;
    private static final Predicate<Method> returnValueMethod = method -> method.getReturnType() != Void.TYPE;
    private static final Predicate<Method> noOverridedObjectMethod = method -> !method.getName().equals("hashCode") && !method.getName().equals("toString");
    private static final Predicate<Method> setterMethod = instanceMethod.and(onceParameterMethod);
    private static final Predicate<Method> getterMethod = instanceMethod.and(noParameterMethod).and(returnValueMethod).and(noOverridedObjectMethod);
    private static final BiPredicate<Parameter, String> hasParameterName = (p, name) -> p.getName().equals(name) || p.getName().equals(NamingFactory.get(NamingStrategy.CAMEL_CASE).apply((String)name)) || p.getName().equals(NamingFactory.get(NamingStrategy.SNAKE_CASE).apply((String)name));
    private static final BiPredicate<Class<?>, Class<?>> hasInstanceMethodWithoutParameterReturnInstanceOfClass = (c, clazz) -> Stream.of(c.getDeclaredMethods()).anyMatch(instanceMethod.and(publicMethod).and(m -> m.getReturnType() == clazz && m.getParameterCount() == 0));

    Reflects() {
    }

    static List<Method> getMethods(Object entity) {
        return Reflects.getMethods(entity, m -> true);
    }

    static List<Method> getMethods(Object entity, Predicate<Method> predicate) {
        Method[] methods = entity.getClass().getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : methods) {
            if (!predicate.test(m)) continue;
            list.add(m);
        }
        return list;
    }

    static List<Method> getGetterMethods(Object entity, ModifierStrategy modifierStrategy) {
        Predicate<Method> predicate = getterMethod.and(Reflects.ignoreTransientMethod());
        if (modifierStrategy == ModifierStrategy.PUBLIC) {
            predicate = predicate.and(publicMethod);
        }
        if (modifierStrategy == ModifierStrategy.PROTECTED) {
            predicate = predicate.and(publicMethod.or(protectedMethod));
        }
        if (modifierStrategy == ModifierStrategy.PACKAGE) {
            predicate = predicate.and(privateMethod.negate());
        }
        return Reflects.getMethods(entity, predicate);
    }

    static Optional<Class<?>> getSetterMethodParameterClass(Object entity, String name) {
        return Reflects.getSetterMethod(entity, name, null).map(m -> m.getParameters()[0]).map(Reflects::getClass);
    }

    static Optional<Method> getSetterMethod(Object entity, String name, Object value) {
        List<Method> methods = Reflects.getMethods(entity, setterMethod).stream().filter(m -> value == null || m.getParameterTypes()[0].isInstance(value)).filter(Reflects.filterMethodName(name).or(Reflects.filterMethodWithJasonerProperty(name))).filter(Reflects.ignoreTransientMethod()).toList();
        return methods.stream().findFirst();
    }

    private static Predicate<Method> filterMethodName(String name) {
        return m -> m.getName().equals(name) || m.getName().equals(NamingFactory.get(NamingStrategy.CAMEL_CASE).apply(name)) || m.getName().equals(NamingFactory.get(NamingStrategy.SNAKE_CASE).apply(name)) || m.getName().equals("set" + Reflects.capitalizeFirstLetter(NamingFactory.get(NamingStrategy.CAMEL_CASE).apply(name))) || m.getName().equals("set" + Reflects.capitalizeFirstLetter(NamingFactory.get(NamingStrategy.SNAKE_CASE).apply(name)));
    }

    private static Predicate<Method> ignoreTransientMethod() {
        return m -> m.getDeclaredAnnotation(JasonerTransient.class) == null;
    }

    private static Predicate<Method> filterMethodWithJasonerProperty(String name) {
        return m -> {
            JasonerProperty annotations = m.getDeclaredAnnotation(JasonerProperty.class);
            String mName = annotations != null ? annotations.value() : m.getName();
            return mName.equals(name) || mName.equals(NamingFactory.get(NamingStrategy.CAMEL_CASE).apply(name)) || mName.equals(NamingFactory.get(NamingStrategy.SNAKE_CASE).apply(name)) || mName.equals("set" + Reflects.capitalizeFirstLetter(NamingFactory.get(NamingStrategy.CAMEL_CASE).apply(name))) || mName.equals("set" + Reflects.capitalizeFirstLetter(NamingFactory.get(NamingStrategy.SNAKE_CASE).apply(name)));
        };
    }

    static String capitalizeFirstLetter(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    static List<Field> getFields(Object entity) {
        return Reflects.getAllFields(new ArrayList<Field>(), entity.getClass());
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            Reflects.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    static List<Field> getFields(Object entity, ModifierStrategy modifierStrategy) {
        List<Field> fields = Reflects.getFields(entity);
        Predicate<Field> predicate = Reflects.ignoreTransientField();
        if (modifierStrategy == ModifierStrategy.PUBLIC) {
            predicate = predicate.and(publicField);
        }
        if (modifierStrategy == ModifierStrategy.PROTECTED) {
            predicate = predicate.and(publicField.or(protectedField));
        }
        if (modifierStrategy == ModifierStrategy.PACKAGE) {
            predicate = predicate.and(privateField.negate());
        }
        return fields.stream().filter(predicate).toList();
    }

    static Optional<Field> getField(Object entity, String name) {
        return Reflects.getFields(entity).stream().filter(Reflects.fieldFieldName(name).or(Reflects.fieldFieldWithJasonerProperty(name))).filter(Reflects.ignoreTransientField()).findFirst();
    }

    private static Predicate<Field> fieldFieldName(String name) {
        return f -> f.getName().equals(name) || f.getName().equals(NamingFactory.get(NamingStrategy.CAMEL_CASE).apply(name)) || f.getName().equals(NamingFactory.get(NamingStrategy.SNAKE_CASE).apply(name));
    }

    private static Predicate<Field> fieldFieldWithJasonerProperty(String name) {
        return f -> {
            JasonerProperty annotation = f.getDeclaredAnnotation(JasonerProperty.class);
            String fieldName = annotation != null ? annotation.value() : f.getName();
            return fieldName.equals(name) || fieldName.equals(NamingFactory.get(NamingStrategy.CAMEL_CASE).apply(name)) || fieldName.equals(NamingFactory.get(NamingStrategy.SNAKE_CASE).apply(name));
        };
    }

    private static Predicate<Field> ignoreTransientField() {
        return f -> f.getDeclaredAnnotation(JasonerTransient.class) == null;
    }

    static Optional<Class<?>> getFieldParameterClass(Object entity, String name) {
        return Reflects.getField(entity, name).map(Field::getType);
    }

    static void setFieldValue(Field field, Object entity, Object value) {
        if (field.trySetAccessible()) {
            try {
                field.set(entity, value);
            }
            catch (IllegalAccessException e) {
                throw new JasonerException(e);
            }
        }
    }

    static <T> Optional<T> createJsonObject(Class<T> clazz) {
        return Optional.ofNullable(clazz.cast(Reflects.createObjectInt(clazz)));
    }

    static Optional<JsonObject> createJsonObject(Class<?> clazz, Object ... args) {
        if (!JsonObject.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format("The class: '%s' is not a JsonObject", clazz.getName()));
        }
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (c.getParameterCount() != args.length || !c.trySetAccessible()) continue;
            try {
                return Optional.of((JsonObject)c.newInstance(args));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JasonerException(e);
            }
        }
        return Reflects.createJsonObject(JsonObjectImpl.class, args);
    }

    private static Object createObjectInt(Class<?> clazz) {
        for (Constructor<?> c : clazz.getDeclaredConstructors()) {
            if (c.getParameterCount() != 0 || !c.trySetAccessible()) continue;
            try {
                return clazz.cast(c.newInstance(new Object[0]));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JasonerException(e);
            }
        }
        return null;
    }

    static Object invokeMethod(Method method, Object obj, Object[] args) {
        try {
            if (method.trySetAccessible()) {
                return method.invoke(obj, args);
            }
            throw new JasonerException(String.format("The method '%s' is not accessible", method.getName()));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new JasonerException(e);
        }
    }

    static Object invokeMethod(Method method, Object obj) {
        return Reflects.invokeMethod(method, obj, null);
    }

    static Optional<Object> createBuilder(Class<?> clazz) {
        Optional<Class> builderClass = Stream.of(clazz.getDeclaredClasses()).filter(c -> hasInstanceMethodWithoutParameterReturnInstanceOfClass.test((Class<?>)c, clazz)).findFirst();
        if (builderClass.isEmpty()) {
            return Optional.empty();
        }
        Optional<Object> instance = builderClass.map(Reflects::createObjectInt);
        if (instance.isPresent()) {
            return instance;
        }
        Optional<Method> method = Stream.of(clazz.getDeclaredMethods()).filter(staticMethod.and(publicMethod).and(m -> m.getReturnType() == builderClass.get() && m.getParameterCount() == 0)).findFirst();
        return method.filter(AccessibleObject::trySetAccessible).map(m -> Reflects.invokeMethod(m, null, null));
    }

    static <T> Optional<T> createObjectFromBuilderInstance(Object builder, Class<T> clazz) {
        return Reflects.getMethods(builder, m -> m.getReturnType() == clazz && m.getParameterCount() == 0).stream().findFirst().map(m -> Reflects.invokeMethod(m, builder, null)).map(clazz::cast);
    }

    private static Class<?> getClass(Parameter parameter) {
        Class<?> clazz = parameter.getType();
        if (clazz == List.class) {
            clazz = Reflects.getClass(parameter.toString());
        }
        return clazz;
    }

    static Class<?> getClass(String str) {
        int p0 = str.indexOf("<");
        int p1 = str.lastIndexOf(">");
        if (p0 != -1 && p1 != -1) {
            try {
                return Class.forName(str.substring(p0 + 1, p1));
            }
            catch (ClassNotFoundException e) {
                throw new JasonerException(e);
            }
        }
        return null;
    }

    static Optional<Class<?>> getRecordParameterClass(Class<?> clazz, String name) {
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException(String.format("The class: '%s' is not a record", clazz.getName()));
        }
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        for (Parameter parameter : constructor.getParameters()) {
            if (!hasParameterName.test(parameter, name)) continue;
            return Optional.of(Reflects.getClass(parameter));
        }
        return Optional.empty();
    }

    static Optional<Class<?>> getSingleRecordParameterClass(Class<?> clazz) {
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException(String.format("The class: '%s' is not a record", clazz.getName()));
        }
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        Parameter[] parameters = constructor.getParameters();
        if (parameters.length == 1) {
            return Optional.of(Reflects.getClass(parameters[0]));
        }
        return Optional.empty();
    }

    static <T> Optional<T> createRecord(Class<T> clazz, Map<String, Object> map) {
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException(String.format("The class: '%s' is not a record", clazz.getName()));
        }
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        if (constructor.trySetAccessible()) {
            List<Object> values = Reflects.getConstructorArgs(map, constructor);
            try {
                return Optional.of(clazz.cast(constructor.newInstance(values.toArray())));
            }
            catch (Exception e) {
                throw new JasonerException(e);
            }
        }
        throw new IllegalArgumentException(String.format("The constructor of the record class: '%s' is not accessible", clazz.getName()));
    }

    static <T> Optional<T> createSingleRecord(Class<T> clazz, Object value) {
        if (!clazz.isRecord()) {
            throw new IllegalArgumentException(String.format("The class: '%s' is not a record", clazz.getName()));
        }
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        if (constructor.trySetAccessible()) {
            try {
                return Optional.of(clazz.cast(constructor.newInstance(value)));
            }
            catch (Exception e) {
                String msg = String.format("Error to create new instance of class: %s with value: %s, cause: %s", clazz.getName(), value, e.getMessage());
                throw new JasonerException(msg);
            }
        }
        throw new IllegalArgumentException(String.format("The constructor of the record class: '%s' is not accessible", clazz.getName()));
    }

    private static List<Object> getConstructorArgs(Map<String, Object> map, Constructor<?> constructor) {
        ArrayList<String> nameParameter = new ArrayList<String>();
        for (Parameter parameter : constructor.getParameters()) {
            nameParameter.add(parameter.getName());
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (String name : nameParameter) {
            values.add(Reflects.getParameter(map, name));
        }
        return values;
    }

    private static Object getParameter(Map<String, Object> map, String name) {
        Object value = map.get(name);
        if (value == null) {
            value = map.get(NamingFactory.get(NamingStrategy.CAMEL_CASE).apply(name));
        }
        if (value == null) {
            value = map.get(NamingFactory.get(NamingStrategy.SNAKE_CASE).apply(name));
        }
        return value;
    }

    public static Object getFieldValue(Field field, Object source) {
        if (field.trySetAccessible()) {
            try {
                return field.get(source);
            }
            catch (IllegalAccessException e) {
                throw new JasonerException(e);
            }
        }
        return null;
    }

    static Optional<JasonerProperty> getJasonerProperty(Class<?> ctype, Enum<?> e) {
        try {
            Field field = ctype.getField(e.name());
            return Optional.ofNullable(field.getAnnotation(JasonerProperty.class));
        }
        catch (NoSuchFieldException ex) {
            return Optional.empty();
        }
    }

    public static <T> T[] createArray(Class<?> clazz, List<?> list) {
        if (clazz.isArray()) {
            Object[] array = (Object[])Array.newInstance(clazz.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                array[i] = list.get(i);
            }
            return array;
        }
        throw new JasonerException("The class is not an array: " + clazz.getName());
    }
}

