/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.JasonerException;
import io.github.eealba.jasoner.JasonerProperty;
import io.github.eealba.jasoner.internal.Reflects;
import io.github.eealba.jasoner.internal.Token;
import io.github.eealba.jasoner.internal.TokenType;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class TokenImpl
implements Token {
    static final Token OBJECT_START = new TokenImpl(TokenType.OBJECT_START, "{");
    static final Token OBJECT_END = new TokenImpl(TokenType.OBJECT_END, "}");
    static final Token ARRAY_START = new TokenImpl(TokenType.ARRAY_START, "[");
    static final Token ARRAY_END = new TokenImpl(TokenType.ARRAY_END, "]");
    static final Token COLON = new TokenImpl(TokenType.COLON, ":");
    static final Token COMMA = new TokenImpl(TokenType.COMMA, ",");
    static final Token FALSE = new TokenImpl(TokenType.FALSE, "false");
    static final Token TRUE = new TokenImpl(TokenType.TRUE, "true");
    static final Token NULL = new TokenImpl(TokenType.NULL, "null");
    private final TokenType type;
    private final String data;

    private TokenImpl(TokenType type, String data) {
        this.type = Objects.requireNonNull(type);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public TokenType type() {
        return this.type;
    }

    @Override
    public Boolean booleanValue() {
        if (this.type == TokenType.TRUE) {
            return Boolean.TRUE;
        }
        if (this.type == TokenType.FALSE) {
            return Boolean.FALSE;
        }
        throw new JasonerException("Invalid value for token type: " + String.valueOf((Object)this.type));
    }

    @Override
    public String stringValue() {
        return this.data;
    }

    @Override
    public BigDecimal numericValue() {
        return this.getPowerDelimiter().map(pos -> new BigDecimal(this.data.substring(0, (int)pos)).pow(Integer.parseInt(this.data.substring(pos + 1)))).orElseGet(() -> new BigDecimal(this.data));
    }

    private Optional<Integer> getPowerDelimiter() {
        int pos = this.data.toLowerCase().indexOf("e");
        if (pos == -1) {
            return Optional.empty();
        }
        return Optional.of(pos);
    }

    static Token createBooleanToken(String value) {
        return new TokenImpl(value.equals("true") ? TokenType.TRUE : TokenType.FALSE, value);
    }

    static Token createNumberToken(String value) {
        return new TokenImpl(TokenType.NUMBER, value);
    }

    static Token createTextToken(String value) {
        return new TokenImpl(TokenType.TEXT, value);
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object typeValue(Class<?> ctype) {
        String name;
        if (this.type() == TokenType.NULL) {
            return null;
        }
        if (ctype == null || Map.class.isAssignableFrom(ctype)) {
            return this.value();
        }
        if (ctype.isEnum()) {
            Enum[] enums;
            for (Enum e : enums = ctype.asSubclass(Enum.class).getEnumConstants()) {
                if (e.name().equals(this.data)) {
                    return e;
                }
                Optional<JasonerProperty> jasonerProperty = Reflects.getJasonerProperty(ctype, e);
                if (!jasonerProperty.isPresent() || !jasonerProperty.get().value().equals(this.data)) continue;
                return e;
            }
            throw new JasonerException("Not found enum for: " + this.data);
        }
        return switch (name = ctype.getSimpleName()) {
            case "int", "Integer" -> Integer.parseInt(this.data);
            case "long", "Long" -> Long.parseLong(this.data);
            case "float", "Float" -> Float.valueOf(Float.parseFloat(this.data));
            case "double", "Double" -> Double.parseDouble(this.data);
            case "String" -> this.data;
            case "BigDecimal" -> this.numericValue();
            case "boolean", "Boolean" -> Boolean.parseBoolean(this.data);
            case "URI" -> URI.create(this.data);
            default -> this.value();
        };
    }

    @Override
    public Object value() {
        if (this.type == TokenType.FALSE || this.type == TokenType.TRUE) {
            return this.booleanValue();
        }
        if (this.type == TokenType.NULL) {
            return null;
        }
        if (this.type == TokenType.NUMBER) {
            return this.numericValue();
        }
        return this.data;
    }
}

